% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSResource.R
\docType{class}
\name{GSResource}
\alias{GSResource}
\title{A GeoServer abstract resource}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer resource
}
\description{
This class models an abstract GeoServer resource. This class is
used internally for modelling instances of class \code{GSFeatureType} or
\code{GSCoverage}
}
\details{
Geoserver REST API Resource
}
\examples{
res <- GSResource$new(rootName = "featureType")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSResource}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{resource name}

\item{\code{nativeName}}{resource native name}

\item{\code{title}}{resource title}

\item{\code{description}}{resource description}

\item{\code{abstract}}{resource abstract}

\item{\code{keywords}}{resource keywords}

\item{\code{metadataLinks}}{resource metadata links}

\item{\code{nativeCRS}}{resource native CRS}

\item{\code{srs}}{resource srs}

\item{\code{nativeBoundingBox}}{resource lat/lon native bounding box}

\item{\code{latLonBoundingBox}}{resource lat/lon bounding box}

\item{\code{projectionPolicy}}{resource projection policy}

\item{\code{enabled}}{enabled}

\item{\code{metadata}}{metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSResource-new}{\code{GSResource$new()}}
\item \href{#method-GSResource-decode}{\code{GSResource$decode()}}
\item \href{#method-GSResource-setEnabled}{\code{GSResource$setEnabled()}}
\item \href{#method-GSResource-setName}{\code{GSResource$setName()}}
\item \href{#method-GSResource-setNativeName}{\code{GSResource$setNativeName()}}
\item \href{#method-GSResource-setTitle}{\code{GSResource$setTitle()}}
\item \href{#method-GSResource-setDescription}{\code{GSResource$setDescription()}}
\item \href{#method-GSResource-setAbstract}{\code{GSResource$setAbstract()}}
\item \href{#method-GSResource-setKeywords}{\code{GSResource$setKeywords()}}
\item \href{#method-GSResource-addKeyword}{\code{GSResource$addKeyword()}}
\item \href{#method-GSResource-delKeyword}{\code{GSResource$delKeyword()}}
\item \href{#method-GSResource-setMetadataLinks}{\code{GSResource$setMetadataLinks()}}
\item \href{#method-GSResource-addMetadataLink}{\code{GSResource$addMetadataLink()}}
\item \href{#method-GSResource-deleteMetadataLink}{\code{GSResource$deleteMetadataLink()}}
\item \href{#method-GSResource-setProjectionPolicy}{\code{GSResource$setProjectionPolicy()}}
\item \href{#method-GSResource-setSrs}{\code{GSResource$setSrs()}}
\item \href{#method-GSResource-setNativeCRS}{\code{GSResource$setNativeCRS()}}
\item \href{#method-GSResource-setLatLonBoundingBox}{\code{GSResource$setLatLonBoundingBox()}}
\item \href{#method-GSResource-setNativeBoundingBox}{\code{GSResource$setNativeBoundingBox()}}
\item \href{#method-GSResource-setMetadata}{\code{GSResource$setMetadata()}}
\item \href{#method-GSResource-delMetadata}{\code{GSResource$delMetadata()}}
\item \href{#method-GSResource-setMetadataDimension}{\code{GSResource$setMetadataDimension()}}
\item \href{#method-GSResource-clone}{\code{GSResource$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GSResource}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$new(rootName = NULL, xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rootName}}{root name}

\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setEnabled}{}}}
\subsection{Method \code{setEnabled()}}{
Set enabled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setEnabled(enabled)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{enabled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setNativeName"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setNativeName}{}}}
\subsection{Method \code{setNativeName()}}{
Set native name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setNativeName(nativeName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nativeName}}{native name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setDescription"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setDescription}{}}}
\subsection{Method \code{setDescription()}}{
Set description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setDescription(description)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{description}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setAbstract}{}}}
\subsection{Method \code{setAbstract()}}{
Set abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setAbstract(abstract)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abstract}}{abstract}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setKeywords}{}}}
\subsection{Method \code{setKeywords()}}{
Set keyword(s)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{keywords}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-addKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-addKeyword}{}}}
\subsection{Method \code{addKeyword()}}{
Adds keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$addKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{keyword}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-delKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-delKeyword}{}}}
\subsection{Method \code{delKeyword()}}{
Deletes keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$delKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{keyword}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setMetadataLinks"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setMetadataLinks}{}}}
\subsection{Method \code{setMetadataLinks()}}{
Set metadata links
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setMetadataLinks(metadataLinks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLinks}}{metadata links}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-addMetadataLink"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-addMetadataLink}{}}}
\subsection{Method \code{addMetadataLink()}}{
Adds metadata link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$addMetadataLink(metadataLink)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLink}}{object of class \link{GSMetadataLink}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-deleteMetadataLink"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-deleteMetadataLink}{}}}
\subsection{Method \code{deleteMetadataLink()}}{
Deletes metadata link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$deleteMetadataLink(metadataLink)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLink}}{object of class \link{GSMetadataLink}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setProjectionPolicy"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setProjectionPolicy}{}}}
\subsection{Method \code{setProjectionPolicy()}}{
Set projection policy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setProjectionPolicy(projectionPolicy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{projectionPolicy}}{projection policy}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setSrs"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setSrs}{}}}
\subsection{Method \code{setSrs()}}{
Set SRS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setSrs(srs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{srs}}{srs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setNativeCRS"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setNativeCRS}{}}}
\subsection{Method \code{setNativeCRS()}}{
Set native CRS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setNativeCRS(nativeCRS)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nativeCRS}}{native crs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setLatLonBoundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setLatLonBoundingBox}{}}}
\subsection{Method \code{setLatLonBoundingBox()}}{
Set LatLon bounding box
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setLatLonBoundingBox(minx, miny, maxx, maxy, bbox = NULL, crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minx}}{minx}

\item{\code{miny}}{miny}

\item{\code{maxx}}{maxx}

\item{\code{maxy}}{maxy}

\item{\code{bbox}}{bbox}

\item{\code{crs}}{crs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setNativeBoundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setNativeBoundingBox}{}}}
\subsection{Method \code{setNativeBoundingBox()}}{
Set native bounding box
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setNativeBoundingBox(minx, miny, maxx, maxy, bbox = NULL, crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minx}}{minx}

\item{\code{miny}}{miny}

\item{\code{maxx}}{maxx}

\item{\code{maxy}}{maxy}

\item{\code{bbox}}{bbox}

\item{\code{crs}}{crs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setMetadata}{}}}
\subsection{Method \code{setMetadata()}}{
Set metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setMetadata(key, metadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{key}

\item{\code{metadata}}{metadata}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-delMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-delMetadata}{}}}
\subsection{Method \code{delMetadata()}}{
Deletes metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$delMetadata(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-setMetadataDimension"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-setMetadataDimension}{}}}
\subsection{Method \code{setMetadataDimension()}}{
Set metadata dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$setMetadataDimension(key, dimension, custom = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{key}

\item{\code{dimension}}{dimension}

\item{\code{custom}}{custom}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
