% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{geo_trim}
\alias{geo_trim}
\title{Trim Away Small Pieces}
\usage{
geo_trim(from, to, thresh = 0.01, bool = FALSE)
}
\arguments{
\item{from}{Required. sf dataframe. the geography to subset}

\item{to}{Required. sf dataframe. the geography that from must intersect}

\item{thresh}{Percent as decimal of an area to trim away. Default is .01, which is 1\%.}

\item{bool}{Optional, defaults to FALSE. Should this just return a logical vector?}
}
\value{
sf data frame or logical vector if bool=TRUE
}
\description{
Trim Away Small Pieces
}
\examples{
\dontrun{
# Needs Census Bureau API
data(towns)
block <- create_block_table('NY', 'Rockland')
geo_trim(block, towns, thresh = 0.05)
}

\donttest{
data(towns)
data(rockland)
sub <- geo_filter(rockland, towns)
rem <- geo_trim(sub, towns, thresh = 0.05)
}
}
\concept{datatable}
