% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcbf.R
\name{plotbf2}
\alias{plotbf2}
\title{Plot the estimated Bayes factors}
\usage{
plotbf2(bf2obj, pars = c("linkp", "phi", "omg", "kappa"),
  profile = length(pars) > 2, ...)
}
\arguments{
\item{bf2obj}{Output from the function \code{\link{bf2new}}.}

\item{pars}{A vector with the names of the parameters to plot.}

\item{profile}{Whether it should produce a profile plot or a
contour plot if the length of pars is 2.}

\item{...}{Other input to be passed to either \code{plot} or
\code{contour}.}
}
\value{
This function returns nothing.
}
\description{
This function plots the estimated logarithm Bayes factors from the
function \code{\link{bf2new}}.
}
\details{
Depending on whether \code{pars} has length 1 or 2, this function
creates a line or a contour plot of the estimated Bayes factors.
If its length is 3 or 4, then it produces multiple profile plots.
In this case the variable is fixed at different values and the
maximum Bayes factor corresponding to the fixed value is plotted
against that value.
}
\examples{
\dontrun{
data(rhizoctonia)
### Define the model
corrf <- "spherical"
kappa <- 0
ssqdf <- 1
ssqsc <- 1
betm0 <- 0
betQ0 <- .01
family <- "binomial.probit"
### Skeleton points
philist <- c(100, 140, 180)
omglist <- c(.5, 1)
parlist <- expand.grid(linkp=0, phi=philist, omg=omglist, kappa = kappa)
### MCMC sizes
Nout <- 100
Nthin <- 1
Nbi <- 0
### Take MCMC samples
runs <- list()
for (i in 1:NROW(parlist)) {
  runs[[i]] <- mcsglmm(Infected ~ 1, family, rhizoctonia, weights = Total,
                       atsample = ~ Xcoord + Ycoord,
                       Nout = Nout, Nthin = Nthin, Nbi = Nbi,
                       betm0 = betm0, betQ0 = betQ0,
                       ssqdf = ssqdf, ssqsc = ssqsc,
                       phi = parlist$phi[i], omg = parlist$omg[i],
                       linkp = parlist$linkp[i], kappa = parlist$kappa[i],
                       corrfcn = corrf,
                       corrtuning=list(phi = 0, omg = 0, kappa = 0))
}
bf <- bf1skel(runs)
bfall <- bf2new(bf, phi = seq(100, 200, 10), omg = seq(0, 2, .2))
plotbf2(bfall, c("phi", "omg"))
plotbf2(bfall, c("phi", "omg"), profile = TRUE, type = "b", ylab="log(BF)")
}
}
