% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca.R
\name{sca}
\alias{sca}
\title{Simultaenous Component Analysis}
\usage{
sca(object)
}
\arguments{
\item{object}{A \code{hdanova} object.}
}
\value{
An updated \code{hdanova} object with SCA results.
}
\description{
This function performs Simultaneous Component Analysis (SCA) on a \code{hdanova} object.
}
\examples{
# Load candies data
data(candies, package="HDANOVA")

# Basic HDANOVA model with two factors
mod <- GEM(assessment ~ candy + assessor, data=candies)
mod <- sca(mod)
scoreplot(mod)
}
\seealso{
Analyses using \code{GEM}: \code{\link{elastic}}, \code{\link{pca}}, \code{\link{sca}}, \code{\link{neuralnet}}, \code{\link{pls}}.
Confidence interval plots: \code{\link{confints}}. Convenience knock-in and knock-out of effects: \code{\link{knock.in}}.
}
