% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform_xy}
\alias{transform_xy}
\title{Transform geospatial x/y coordinates}
\usage{
transform_xy(pts, srs_from, srs_to)
}
\arguments{
\item{pts}{A data frame or numeric matrix containing geospatial point
coordinates, or point geometries as a list of WKB raw vectors or character
vector of WKT strings. If data frame or matrix, the number of columns must
be either two (x, y), three (x, y, z) or four (x, y, z, t).
May be also be given as a numeric vector for one point (xy, xyz, or xyzt).}

\item{srs_from}{Character string specifying the spatial reference system
for \code{pts}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{srs_to}{Character string specifying the output spatial reference
system. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}
}
\value{
Numeric matrix of geospatial (x, y) coordinates in the projection
specified by \code{srs_to} (potentially also with z, or z and t columns).
}
\description{
\code{transform_xy()} transforms geospatial x, y coordinates to a new
projection. The input points may optionally have z vertices (x, y, z) or
time values (x, y, z, t).
Wrapper for \code{OGRCoordinateTransformation::Transform()} in the GDAL Spatial
Reference System C++ API.
}
\note{
\code{transform_xy()} uses traditional GIS order for the input and output xy
(i.e., longitude/latitude ordered for geographic coordinates).

Input points that contain missing values (\code{NA}) will be assigned \code{NA} in
the output and a warning emitted. Input points that fail to transform
with the GDAL API call will also be assigned \code{NA} in the output with a
specific warning indicating that case.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
pts <- read.csv(pt_file)
print(pts)
# id, x, y in NAD83 / UTM zone 12N
# transform to NAD83 / CONUS Albers
transform_xy(pts = pts[, -1], srs_from = "EPSG:26912", srs_to = "EPSG:5070")
}
\seealso{
\code{\link[=srs_to_wkt]{srs_to_wkt()}}, \code{\link[=inv_project]{inv_project()}}
}
