% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_name}
\alias{g_name}
\title{Extract the geometry type name from a WKT geometry}
\usage{
g_name(wkt)
}
\arguments{
\item{wkt}{Character. OGC WKT string for a simple feature geometry.}
}
\value{
WKT name for this geometry type.
}
\description{
\code{g_name()} returns the name for this geometry type in well known text
format.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)
bbox_to_wkt(ds$bbox()) |> g_name()
ds$close()
}
