% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blc_sm.R
\name{smooth}
\alias{smooth}
\title{Smoothing}
\usage{
smooth(data, lambda = 20, dir = "XY")
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{lambda}{a \emph{float} object. A number (parameter in Whittaker
smoothing), suggested between 0 to 10^4. Small lambda is very little
smoothing, large lambda is very smooth. Default is lambda = 20.}

\item{dir}{a \emph{string} object. Either "X", "Y", or "XY" to indicate
direction of smoothing. "XY" indicates smoothing in both X (horizontal) and Y
(vertical) directions. Default "XY".}
}
\value{
A \emph{data.frame} object. A list of two data frames. A TIC data
frame and an MS data frame.
}
\description{
\code{smooth} performs smoothing of the intensity values.
}
\details{
This function performs smoothing of the intensity values using
Whittaker smoothing algorithm \code{\link[ptw]{whit1}} from the ptw package
\insertCite{ptw}{gcxgclab}.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
sm_frame <- smooth(frame, lambda=10)
plot_chr(sm_frame, title='Smoothed')

}
\references{
\insertAllCited{}
}
