% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations.R
\name{create_equations}
\alias{create_equations}
\title{Create a list of equations for recalculating gasanalyzer data.}
\usage{
create_equations(useflags = "default", ...)
}
\arguments{
\item{useflags}{character vector with the type of equations to create
(such as c("li6800", "gfs3000")). Leave empty to obtain the default set.
An unknown flag returns an empty list, and a warning listing all valid
flags.}

\item{...}{custom equations. the arguments must tagged function expressions.
Note that the function body must be wrapped in curly brackets. The tags
will be matched against the names of a data frame when applying the return
value with \code{\link[=recalculate]{recalculate()}}.}
}
\value{
A list of language objects with equations
}
\description{
This function creates a list of equations that can be used to recalculate
gas-exchange data by passing the resulting object to the \code{\link[=recalculate]{recalculate()}}
method. Various \code{useflags} can be defined to tune the equations.
In addition, custom equations can be defined as arguments. Note that
the calculations may fail if commons are missing in the gas-exchange data.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")

# import factory calibration for example data:
import_factory_cals(exampledir)

# read data from a txt file:
li6800 <- read_6800_txt(paste0(exampledir, "//lowo2"))

# passing an invalid flags shows which flags are valid:
\donttest{create_equations("help")}

# create a default set of gas-exchange equations, for the 6800, but overwrite
# the default calculation of leaf light absorption with a custom value:
Eqs <- create_equations(c("default", "li6800"), LeafQ.alpha = \() {0.86})

#apply:
li6800_recalc <- recalculate(li6800, Eqs)

li6800$LeafQ.alpha
li6800_recalc$LeafQ.alpha
}
\seealso{
\code{\link[=read_6800_equations]{read_6800_equations()}}
}
