% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.galamm.R
\name{plot.galamm}
\alias{plot.galamm}
\title{Diagnostic plots for galamm objects}
\usage{
\method{plot}{galamm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{galamm} returned from \code{\link{galamm}}.}

\item{...}{Optional arguments passed on to the \code{plot} function.}
}
\value{
A plot is displayed.
}
\description{
Diagnostic plots for galamm objects
}
\examples{
# Linear mixed model example from lme4
data("sleepstudy", package = "lme4")
mod <- galamm(Reaction ~ Days + (Days | Subject), data = sleepstudy)

# Diagnostic plot
plot(mod)

}
\seealso{
\code{\link[=residuals.galamm]{residuals.galamm()}} for extracting residuals and \code{\link[=plot]{plot()}} for the
generic function.

Other summary functions: 
\code{\link{anova.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.galamm}()},
\code{\link{print.summary.galamm}()},
\code{\link{summary.galamm}()}
}
\concept{summary functions}
