% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsea.R
\name{rmsea}
\alias{rmsea}
\title{Calculate RMSEA between two correlation matrices}
\usage{
rmsea(Sigma, Omega, k)
}
\arguments{
\item{Sigma}{(matrix) Population correlation or covariance matrix (with model
error).}

\item{Omega}{(matrix) Model-implied population correlation or covariance
matrix.}

\item{k}{(scalar) Number of major common factors.}
}
\description{
Given two correlation matrices of the same dimension, calculate the RMSEA
value using the degrees of freedom for the exploratory factor analysis model
(see details).
}
\details{
Note that this function uses the degrees of freedom for an
exploratory factor analysis model: \deqn{df = p(p-1)/2-(pk)+k(k-1)/2,}
where \eqn{p} is the number of items and \eqn{k} is the number of major
factors.
}
\examples{
mod <- fungible::simFA(Model = list(NFac = 3),
                       Seed = 42)
set.seed(42)
Omega <- mod$Rpop
Sigma <- noisemaker(
  mod = mod,
  method = "CB",
  target_rmsea = 0.05
)$Sigma
rmsea(Sigma, Omega, k = 3)
}
