% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TR.R
\name{TR}
\alias{TR}
\title{Estimate the parameters of the Taylor-Russell function.}
\usage{
TR(BR = NULL, SR = NULL, CV = NULL, PPV = NULL, PrintLevel = 1, Digits = 3)
}
\arguments{
\item{BR}{(numeric): The Base Rate of successful criterion performance 
(i.e., within the target population, the proportion of individuals who can 
successfully execute the job demands).}

\item{SR}{(numeric): The Selection Ratio. A real number between 0 and 1
that denotes the test selection ratio (i.e., the proportion of hired 
candidates from the target population).}

\item{CV}{(numeric) The correlation (Criterion Validity) between the selection test 
and a measure of job performance.}

\item{PPV}{(numeric): The Positive Predicted Value. The PPV denotes 
the probability that a hired candidate has the necessary skills to 
succeed on the job.}

\item{PrintLevel}{(integer): If \code{PrintLevel = 0} then no output will be printed to screen. 
If \code{PrintLevel = 1} then a brief summary of output is printed to screen. Default \code{PrintLevel = 1}.}

\item{Digits}{(integer) Controls the number of significant digits 
in the printed output.}
}
\value{
\itemize{
   \item  \strong{BR} The base rate.
   \item \strong{SR} The selection ratio.
   \item \strong{CV} The criterion validity.
   \item  \strong{PPV} The positive predictive value.
   \item \strong{Sensitivity} The test sensitivity rate. 
   \item \strong{Specificity}  The test specificity rate. 
   \item \strong{TP} The selection True Positive rate. 
   \item \strong{FP} The selection False Positive rate. 
   \item \strong{TN} The selection True Negative rate. 
   \item \strong{FN} The selection False Negative rate. 
}
}
\description{
A Taylor-Russell function can be computed with any three of the following 
four variables: the Base Rate (BR); the Selection Ratio (SR); 
the Criterion Validity (CV) and the Positive Predictive Value (PPV). 
The \code{TR()} function will compute a Taylor Russell function 
when given any three of these parameters and estimate the remaining parameter.
}
\details{
When any three of the main program arguments (BR, SR, CV, PPV) are specified (with the 
 remaining argument given a NULL value), \code{TR()} will calculate 
 the model-implied value for the remaining variable.  It will also compute the test Sensitivity 
 (defined as the probability that a qualified individual will be hired) and 
 test Specificity (defined as the probability that an unqualified individual 
 will not be hired), the True Positive rate, the False Positive rate, the 
 True Negative rate, and the False Negative rate.
}
\examples{

## Example 1:
       TR(BR = .3, 
          SR = NULL, 
          CV = .3, 
          PPV = .5,
          PrintLevel = 1,
          Digits = 3)
  
## Example 2:

       TR(BR = NULL, 
          SR = .1012, 
          CV = .3, 
          PPV = .5,
          PrintLevel = 1,
          Digits = 3)
   
## Example 3: A really bad test!
 # If the BR > PPV then the actual test
 # validity is zero. Thus, do not use the test!

       TR(BR = .50, 
          SR = NULL, 
          CV = .3, 
          PPV = .25,
          PrintLevel = 1,
          Digits = 3)   
}
\references{
\itemize{
  \item Taylor, H. C. & Russell, J. (1939). The relationship of validity 
  coefficients to the practical effectiveness of tests in selection: 
  Discussion and tables. \emph{Journal of Applied Psychology, 23}, 565--578.
 }
}
\author{
\itemize{
  \item Niels G. Waller (nwaller@umn.edu)
}
}
\keyword{stats}
