% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrcc.R
\name{FMRCC_PhaseI}
\alias{FMRCC_PhaseI}
\title{Phase I of the FMRCC}
\usage{
FMRCC_PhaseI(
  Y_train,
  X_train,
  Y_tun,
  X_tun,
  FVEy,
  FVEx,
  studentized = T,
  alpha = 0.01,
  intercept = T,
  init_met = "kmeans",
  ninit = 10,
  groups = 1:5,
  sigma_par = c("VVV", "EEE", "VII", "EII"),
  scale = T,
  ncompx = NULL,
  ncompy = NULL,
  userBwCov = NULL
)
}
\arguments{
\item{Y_train}{Training response variable. Object of class \code{'mfd'} (dense
functional data) or \code{'list'} (sparse functional data). For dense data,
\code{\link{pca_mfd}} is performed. For sparse data, PACE (Yao et al., 2005)
via \code{\link[fdapace]{FPCA}} is used.}

\item{X_train}{Training predictor variables. Object of class \code{'mfd'} (dense
functional), \code{'matrix'} (scalar), or \code{'list'} (sparse functional).
For dense data, \code{\link{pca_mfd}} is performed. For sparse data, PACE
(Yao et al., 2005) via \code{\link[fdapace]{FPCA}} is used.}

\item{Y_tun}{Tuning response variable for control limit calculation. Must be
same type as \code{Y_train}.}

\item{X_tun}{Tuning predictor variables for control limit calculation. Must be
same type as \code{X_train}.}

\item{FVEy}{Fraction of variance explained threshold for response variable.}

\item{FVEx}{Fraction of variance explained threshold for covariates.
Ignored if covariates are scalar.}

\item{studentized}{Logical. If \code{TRUE}, statistics are studentized. Default is \code{TRUE}.}

\item{alpha}{Type I error rate for control limit calculation. Default is \code{0.01}.}

\item{intercept}{Logical. If \code{TRUE}, model includes an intercept. Default is \code{TRUE}.}

\item{init_met}{Initialization method: \code{'kmeans'} or \code{'random'}. If
\code{'random'}, \code{ninit} initializations are performed and the model with
lowest BIC is retained. Default is \code{'kmeans'}.}

\item{ninit}{Number of random starts for model estimation. Ignored if
\code{init_met = 'kmeans'}. Default is \code{10}.}

\item{groups}{Integer vector specifying number of mixture components to consider.
Default is \code{1:5}.}

\item{sigma_par}{Character vector of covariance parametrizations to consider.
Options are \code{'VVV'} (variable volume, shape, orientation), \code{'EEE'}
(equal volume, shape, orientation), \code{'VII'} (variable volume, spherical),
\code{'EII'} (equal volume, spherical). Default is \code{c('VVV','EEE','VII','EII')}.}

\item{scale}{Logical. Should dense functional objects be scaled? Default is \code{TRUE}.}

\item{ncompx}{Integer. Number of principal components to retain for functional
covariates. If \code{NULL}, chosen according to \code{FVEx}. Default is \code{NULL}.}

\item{ncompy}{Integer. Number of principal components to retain for functional
response. If \code{NULL}, chosen according to \code{FVEy}. Default is \code{NULL}.}

\item{userBwCov}{Bandwidth for covariance smoothing in PACE. See \code{\link[fdapace]{FPCA}}
for details. Default is \code{NULL}.}
}
\value{
A list containing:
\item{model}{The best fitted mixture regression model}
\item{phaseI}{Phase I results including control limits}
\item{estimate}{Estimation results including values to studentize residuals}
\item{fpca}{FPCA results for response and (if applicable) covariates}
\item{BIC_plt}{ggplot object showing BIC values across models}
\item{studentized}{Logical indicating if studentization was used}
\item{intercept}{Logical indicating if intercept was included}
\item{type_y}{Character indicating response type ('dense' or 'sparse')}
\item{type_x}{Character indicating covariate type ('dense', 'sparse', or 'scalar')}
}
\description{
Performs Phase I of the Functional Mixture Regression Control Chart methodology,
which consists of model estimation
and control limit calculation using training and tuning datasets.
}
\examples{
\donttest{
# Example with dense functional data
# Length of the functional grid
l <- 100
# Number of observations
n <- 300

# Generate training in-control data with three equally-sized clusters, maximum dissimilarity
data <- simulate_data_fmrcc(n_obs = n, delta_1 = 1, delta_2 = 0.5, len_grid = l, severity = 0)
X_train_mfd <- get_mfd_list(data_list = data['X'], n_basis = 20)
Y_train_mfd <- get_mfd_list(data_list = data['Y'], n_basis = 20)

# Generate tuning in-control data with three equally-sized clusters, maximum dissimilarity
data <- simulate_data_fmrcc(n_obs = n, delta_1 = 1, delta_2 = 0.5, len_grid = l, severity = 0)
X_tun_mfd <- get_mfd_list(data_list = data['X'], n_basis = 20)
Y_tun_mfd <- get_mfd_list(data_list = data['Y'], n_basis = 20)

# Example with dense functional data
phaseI_results <- FMRCC_PhaseI(
  Y_train = Y_train_mfd,
  X_train = X_train_mfd,
  Y_tun = Y_tun_mfd,
  X_tun = X_tun_mfd,
  FVEy = 0.95,
  FVEx = 0.90,
  alpha = 0.01,
  groups = 1:3,
  sigma_par = c('VVV', 'EEE')
)

# View BIC plot
phaseI_results$BIC_plt
}
}
\references{
Capezza, C., Centofanti, F., Forcina, D., Lepore, A., & Palumbo, B. (2025).
Functional Mixture Regression Control Chart. Accepted for publication in \emph{Annals of Applied Statistics}.
arXiv:2410.20138.

Yao, F., Müller, H. G., & Wang, J. L. (2005). Functional data analysis for sparse
longitudinal data. \emph{Journal of the American Statistical Association}, 100(470),
577-590.
}
\seealso{
\code{\link{FMRCC_PhaseII}}, \code{\link[fdapace]{FPCA}}
}
