% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_extract.R
\name{ft_extract}
\alias{ft_extract}
\title{Extract text from a single pdf document}
\usage{
ft_extract(x)
}
\arguments{
\item{x}{Path to a pdf file, or an object of class \code{ft_data}, the
output from \code{\link[=ft_get]{ft_get()}}}
}
\value{
An object of class \code{pdft_char} in the case of character input,
or of class \code{ft_data} in the case of \code{ft_data} input
}
\description{
\code{ft_extract} attemps to make it easy to extract text from
PDFs, using \pkg{pdftools}. Inputs can be either paths to PDF
files, or the output of \code{\link[=ft_get]{ft_get()}} (class \code{ft_data}).
}
\examples{
\dontrun{
path <- system.file("examples", "example1.pdf", package = "fulltext")
(res <- ft_extract(path))

# use on output of ft_get() to extract pdf to text
## arxiv
res <- ft_get('cond-mat/9309029', from = "arxiv")
res2 <- ft_extract(res)
res$arxiv$data
res2$arxiv$data

## biorxiv
res <- ft_get('10.1101/012476')
res2 <- ft_extract(res)
res$biorxiv$data
res2$biorxiv$data
}
}
