% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslroi.R
\name{fslroi}
\alias{fslroi}
\alias{fsl_roi}
\alias{fslroi_time}
\title{FSL ROI}
\usage{
fslroi(
  file,
  xmin = 0,
  xsize = -1,
  ymin = 0,
  ysize = -1,
  zmin = 0,
  zsize = -1,
  tmin = NULL,
  tsize = NULL,
  outfile = NULL,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  verbose = TRUE,
  ...
)

fsl_roi(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fslroi_time(file, tmin = NULL, tsize = NULL, ...)
}
\arguments{
\item{file}{(character) image to be manipulated}

\item{xmin}{Minimum index for x-dimension}

\item{xsize}{Size of ROI in x-dimension}

\item{ymin}{Minimum index for y-dimension}

\item{ysize}{Size of ROI in y-dimension}

\item{zmin}{Minimum index for z-dimension}

\item{zsize}{Size of ROI in z-dimension}

\item{tmin}{Minimum index for t-dimension}

\item{tsize}{Size of ROI in t-dimension}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is \code{TRUE} or 
\code{FALSE}.
}
\description{
This function calls \code{fslroi}
}
\note{
Indexing (in both time and space) starts with 0 not 1! 
Inputting -1 for a size will set it to the full image extent for that dimension.
}
