% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslmin_max.R
\name{fslmax}
\alias{fslmax}
\alias{fslmin}
\title{Get min/max of an image}
\usage{
fslmax(file, ...)

fslmin(file, ...)
}
\arguments{
\item{file}{(character) filename of image to be checked}

\item{...}{options passed to \code{\link{fslrange}}}
}
\value{
Numeric vector of mins/maxs or just one depending if \code{ts = TRUE}
}
\description{
This function calls the range or robust range functions from FSL 
and then extracts the min/max
}
\examples{
if (have.fsl()){
 mnifile = file.path(fsldir(), "data", "standard", 
   "MNI152_T1_2mm.nii.gz")
 fslmax(mnifile)
}  
}
