% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseSim.R
\name{markerSimParametric}
\alias{markerSimParametric}
\title{Simulate marker data given IBD coefficients}
\usage{
markerSimParametric(
  kappa = NULL,
  delta = NULL,
  states = NULL,
  N = 1,
  alleles = NULL,
  afreq = NULL,
  seed = NULL,
  returnValue = c("singletons", "alleles", "genotypes")
)
}
\arguments{
\item{kappa}{A probability vector of length 3, giving a set of realised kappa
coefficients (between two noninbred individuals).}

\item{delta}{A probability vector of length 9, giving a set of condensed
identity coefficients (Jacquard coefficients).}

\item{states}{An integer vector of length \code{N}, with entries in 1-9. Each
entry gives the identity state of the corresponding marker. (See details.)}

\item{N}{A positive integer: the number of independent markers to be
simulated.}

\item{alleles}{A vector with allele labels. If NULL, the following are tried
in order:
\itemize{
\item \code{names(afreq)}
\item `seq_along(afreq)'
\item \code{1:2} (fallback if both \code{alleles} and \code{afreq} are NULL)
}}

\item{afreq}{A numeric vector with allele frequencies, possibly named with
allele labels.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{returnValue}{Either "singleton" (default) or "alleles". (see Value).}
}
\value{
If \code{returnValue == "singletons"}, a list of two singletons with the
simulated marker data attached.

If \code{returnValue == "alleles"}, a list of four vectors of length \code{N}, named
\code{a}, \code{b}, \code{c} and  \code{d}. These contain the simulated alleles, where a/b and
c/d are the genotypes of the to individuals.

If \code{returnValue == "genotypes"}, a list of two vectors of length \code{N},
containing the simulated genotypes. Identical to \code{paste(a, b, sep = "/")}
and \code{paste(c, d, sep = "/")}, where \code{a}, \code{b}, \code{c}, \code{d} are the vectors
returned when \code{returnValue == "alleles"}.
}
\description{
This function simulates genotypes for two individuals given their IBD
distribution, for N identical markers.
}
\details{
Exactly one of \code{kappa}, \code{delta} and \code{states} must be given; the other two
should remain NULL.

If \code{states} is given, it explicitly determines the condensed identity state
at each marker. The states are described by integers 1-9, using the tradition
order introduced by Jacquard.

If \code{kappa} is given, the states are generated by the command \code{states = sample(9:7, size = N, replace = TRUE, prob = kappa)}. (Note that identity
states 9, 8, 7 correspond to IBD status 0, 1, 2, respectively.)

If \code{delta} is given, the states are generated by the command \code{states = sample(1:9, size = N, replace = TRUE, prob = delta)}.
}
\examples{
# MZ twins
markerSimParametric(kappa = c(0,0,1), N = 5, alleles = 1:10)

# Equal distribution of states 1 and 2
markerSimParametric(delta = c(.5,.5,0,0,0,0,0,0,0), N = 5, alleles = 1:10)

# Force a specific sequence of states
markerSimParametric(states = c(1,2,7,8,9), N = 5, alleles = 1:10)

}
