% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createExpSpace.R
\name{createExpSpace}
\alias{createExpSpace}
\title{Creates exposure space of hydroclimatic targets for generation of scenarios using 'generateScenarios'}
\usage{
createExpSpace(
  attPerturb,
  attPerturbSamp,
  attPerturbMin,
  attPerturbMax,
  attPerturbType = "regGrid",
  attPerturbBy = NULL,
  attHold = NULL,
  attTargetsFile = NULL
)
}
\arguments{
\item{attPerturb}{A char vector; the names of the attributes to be perturbed. 
This vector can contain attributes of different hydroclimatic variables.}

\item{attPerturbSamp}{An integer vector; the number of samples for each attribute \code{attPerturb}. 
The length of this vector should be equal to the length of \code{attPerturb}.}

\item{attPerturbMin}{A numeric vector; the minimum bounds for sampling of \code{attPerturb}. 
The length of this vector should be equal to the length of \code{attPerturb}. 
For variables like precipitation, evapotranspiration, radiation, etc. \code{attPerturbMin} should specified as a fraction of the original 
(eg: 0.9 = 90\% of the original attribute). For temperature, \code{attPerturbMin} should be specified in K (eg: 0.9 = 0.9 K).}

\item{attPerturbMax}{A numeric vector; the maximum bounds for sampling of \code{attPerturb}. 
The length of this vector should be equal to the length of \code{attPerturb}. 
For variables like precipitation, evapotranspiration, radiation, etc. \code{attPerturbMax} should specified as a fraction of the original 
(eg: 0.9 = 90\% of the original attribute). For temperature, \code{attPerturbMax} should be specified in K (eg: 0.9 = 0.9 K).
Note that to create a single sample of the attribute, \code{attPerturbSamp} could be specified as 1 with \code{attPerturbMin} and \code{attPerturbMax} specified as equal.}

\item{attPerturbType}{A string to specify the type of sampling, defaults to regular spacing. Valid sampling types are:
\itemize{
\item "regGrid" a regular grid sampling all the attributes specified in \code{attPerturb} simultaneously
\item "OAT" one-at-a-time sampling of the attributes specified in \code{attPerturb}
}}

\item{attPerturbBy}{A numeric vector; increment of values to create samples between \code{attPerturbMin} and \code{attPerturbMax}.
If \code{attPerturbBy} is specified, attPerturbSamp should be set as \code{NULL}.}

\item{attHold}{A char vector; the names of the attributes to be held at historical levels. 
This vector can contain attributes of different hydroclimatic variables.}

\item{attTargetsFile}{String specifying the full path to a CSV file containing the target exposure space. 
The column names in the file should correspond to the attributes specified in \code{attPerturb} and \code{attHold}. 
\code{attTargetsFile} is alternate way to specify exposure space targets that do not form a regular grid. 
If \code{attTargetsFile} is specified, the inputs arguments \code{attPerturbSamp}, \code{attPerturbMin}, \code{attPerturbMax}, 
and \code{attPerturbType} should be set to \code{NULL} and will not be used by the function.}
}
\value{
The exposure space as a list containing the following fields:
\itemize{
\item \code{targetMat} a dataframe or matrix; each column is a perturb/hold attribute, each row is a point in the exposure space.
\item \code{attRot} a char vector containing the one-at-a-time ("OAT") attributes associated with \code{targetMat}, \code{attRot} is \code{NULL} for other types of sampling.
\item \code{attPerturb}, \code{attHold}, \code{attPerturbSamp}, \code{attPerturbMin}, \code{attPerturbMax}, \code{attPerturbType} in the  function input arguments, if not \code{NULL}.
}
}
\description{
\code{createExpSpace} returns a list containing the targets (\code{targetMat}) and the metadata (input arguments) used to create the exposure space.
}
\details{
The list of valid attributes that may be specified using \code{attPerturb} or \code{attHold} can be viewed using the function
\code{viewAttributes()}. The definition of the attribute can be viewed using the function \code{viewAttributeDef}.
}
\examples{
# To view the valid attributes. The function does not take any input arguments. 
viewAttributes()

# To view the definition of any valid attribute
viewAttributeDef("P_ann_tot_m")

# To create an exposure space of points on a regular grid
attPerturb <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m")
attPerturbType <- "regGrid"
attPerturbSamp <- c(3, 1, 1)
attPerturbMin <- c(0.9, 1, 1)
attPerturbMax <- c(1.1, 1, 1)
attHold <- c("P_Feb_tot_m", "P_SON_dyWet_m", "P_JJA_avgWSD_m", 
"P_MAM_tot_m", "P_DJF_avgDSD_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
expSpace <- createExpSpace(attPerturb = attPerturb, attPerturbSamp = attPerturbSamp, 
attPerturbMin = attPerturbMin, attPerturbMax = attPerturbMax, 
attPerturbType = attPerturbType, attHold = attHold, attTargetsFile = NULL)

# Using attPerturbBy to specify the increment of perturbation (attPerturbSamp set to NULL)

attPerturb <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m")
attPerturbType <- "regGrid"
attPerturbMin <- c(0.9, 1, 1)
attPerturbMax <- c(1.1, 1, 1)
attPerturbBy <- c(0.1, 0, 0)
attHold <- c("P_Feb_tot_m", "P_SON_dyWet_m", "P_JJA_avgWSD_m", "P_MAM_tot_m", 
"P_DJF_avgDSD_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
expSpace <- createExpSpace(attPerturb = attPerturb, attPerturbSamp = NULL, 
attPerturbMin = attPerturbMin, attPerturbMax = attPerturbMax, attPerturbType = attPerturbType, 
attPerturbBy = attPerturbBy, attHold = attHold, attTargetsFile = NULL)

# To create an exposure space of observed attributes without perturbation
# Note that attPerturbMin and attPerturbMax values are set to 1 for variables like precipitation, 
# and 0 for temperature 
attPerturb <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m", "Temp_DJF_avg_m")
attPerturbType <- "regGrid"
attPerturbSamp <- c(1, 1, 1, 1)
attPerturbMin <- c(1, 1, 1, 0)
attPerturbMax <- c(1, 1, 1, 0)
expSpace <- createExpSpace(attPerturb = attPerturb, attPerturbSamp = attPerturbSamp, 
attPerturbMin = attPerturbMin, attPerturbMax = attPerturbMax, attPerturbType = attPerturbType, 
attHold = NULL, attTargetsFile = NULL)
}
\seealso{
\code{generateScenarios}, \code{viewAttributes}, \code{viewAttributeDef}
}
