% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_units.R
\name{flux_units}
\alias{flux_units}
\title{Unit conversion coefficient for fluxes}
\usage{
flux_units(
  flux_units,
  conc_units,
  conc_units_list = c("mmol/mol", "ppm", "ppb", "ppt"),
  amount_units = c("mol", "mmol", "umol", "nmol", "pmol"),
  surface_units = c("m2", "dm2", "cm2"),
  time_units = c("d", "h", "mn", "s")
)
}
\arguments{
\item{flux_units}{desired units for the calculated fluxes. Has to be of the
form amount/time/surface. Amount can be \code{mol}, \code{mmol}, \code{umol}, \code{nmol} or
\code{pmol}. Time can be \code{d} (day), \code{h} (hour), \code{mn} (minute) or \code{s} (seconds).
Surface can be \code{m2}, \code{dm2} or \code{cm2}.}

\item{conc_units}{units of gas concentration \code{mmol/mol}, \code{ppm}, \code{ppb} or
\code{ppt}.}

\item{conc_units_list}{list of possible units for gas concentration.}

\item{amount_units}{list of possible units for amount.}

\item{surface_units}{list of possible units for surface.}

\item{time_units}{list of possible units for time.}
}
\value{
A single numerical to multiply flux values with to convert units.
}
\description{
calculates the conversion coefficient for flux_calc
}
\details{
The conversion is done from umol/s/m2 and gas concentration
measured in ppm.
}
\examples{
flux_units("mol/m2/mn", "ppm")
}
