% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_zebra}
\alias{theme_zebra}
\title{Apply zebra theme}
\usage{
theme_zebra(
  x,
  odd_header = "#CFCFCF",
  odd_body = "#EFEFEF",
  even_header = "transparent",
  even_body = "transparent"
)
}
\arguments{
\item{x}{a flextable object}

\item{odd_header, odd_body, even_header, even_body}{odd/even colors for table header and body}
}
\description{
Apply theme zebra to a flextable
}
\section{Illustrations}{


\if{html}{\figure{fig_theme_zebra_1.png}{options: width=60\%}}
}

\examples{
ft <- flextable(head(airquality))
ft <- theme_zebra(ft)
ft
}
\seealso{
Other functions related to themes: 
\code{\link{get_flextable_defaults}()},
\code{\link{set_flextable_defaults}()},
\code{\link{theme_alafoli}()},
\code{\link{theme_booktabs}()},
\code{\link{theme_box}()},
\code{\link{theme_tron_legacy}()},
\code{\link{theme_tron}()},
\code{\link{theme_vader}()},
\code{\link{theme_vanilla}()}
}
\concept{functions related to themes}
