% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{inv_poly}
\alias{inv_poly}
\alias{fw_poly}
\title{Polynomial Functions}
\usage{
inv_poly(x, coefs, lb = -1000, ub = 1000)

fw_poly(y, coefs)
}
\arguments{
\item{x}{Scalar polynomial function input.}

\item{coefs}{Vector of coefficients that define a monotonic polynomial,
see details.}

\item{lb}{Lower bound of the search interval.}

\item{ub}{Upper bound of the search interval.}

\item{y}{Scalar polynomial function output.}
}
\description{
Evaluate a forward or inverse (monotonic) polynomial function.
}
\details{
\deqn{x = t_0 + t_1y + t_2y^2 + ...}{x = t0 + t1*y + t2*y^2 + ...}
Then, for coefs = \eqn{(t_0, t_1, t_2, ...)^\prime}{(t0, t1, t2, ...)'},
this function finds the corresponding
\eqn{y} value (inv_poly) or \eqn{x} value (fw_poly).
}
