% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.OR.R
\name{predict.OR}
\alias{predict.OR}
\title{predict.OR : Predict Method for OR Objects}
\usage{
\method{predict}{OR}(
  object,
  predictor,
  prob = NULL,
  ref.value = NULL,
  conf.level = 0.95,
  prediction.values = NULL,
  round.x = NULL,
  ref.label = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class "OR."}

\item{predictor}{The predictor variable for which you want to make predictions.}

\item{prob}{Probability value for prediction. Use 0 for point prediction,
0.5 for median, or a custom value between 0 and 1.}

\item{ref.value}{Optional custom prediction value (use with prob=NULL).}

\item{conf.level}{Confidence level for prediction intervals (default is 0.95).}

\item{prediction.values}{Vector of specific prediction values to calculate.}

\item{round.x}{Number of decimal places to round the prediction values (default is 5).}

\item{ref.label}{Label for the predictor variable in the output (optional).}

\item{...}{Additional arguments (not used in this function).}
}
\value{
A matrix with predicted values and prediction intervals.
}
\description{
Predicts values using a fitted OR model.
}
\details{
This function predicts values and prediction intervals using a fitted OR model.
}
\examples{
library(gam);

# Load the Pima Indians Diabetes dataset
data(PimaIndiansDiabetes2, package="mlbench");

# Calculate smooth odds ratios using flexOR
mod1 <- flexOR(
  data=PimaIndiansDiabetes2,
  response="diabetes",
  formula= ~ s(age) + s(mass) + s(pedigree) + pressure + glucose
);

# Predict the probabilities using predict.OR
predict(mod1, predictor="age", ref.value=40) 

}
\keyword{methods}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
