% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexOR.R
\name{flexOR}
\alias{flexOR}
\title{flexOR: Flexible Odds Ratio Computation for GAM Models}
\usage{
flexOR(data, response = NULL, formula = NULL)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{response}{The response variable as a character string.}

\item{formula}{A formula specifying the model.}
}
\value{
A list containing the following components:
\itemize{
  \item \code{dataset}: The dataset used for the analysis.
  \item \code{formula}: The formula used in the GAM model.
  \item \code{gamfit}: The fitted GAM model.
  \item \code{response}: The response variable used in the analysis.
}
}
\description{
Computes odds ratios for predictors in GAM models.
It provides flexibility in specifying predictors using either a data frame,
a response variable, and a formula or a pre-fitted GAM model.
The function is useful for understanding the impact of predictors on
binary outcomes in GAMs.
}
\details{
It accepts two different ways of specifying the model: by providing
the data frame and response variable or by specifying the formula.
}
\examples{
library(gam);

# Load dataset
data(PimaIndiansDiabetes2, package="mlbench");

# Calculate odds ratios using flexOR
df_result <- flexOR(data = PimaIndiansDiabetes2, response = "diabetes", 
formula=~ s(age) + s(mass) + s(pedigree) + pressure + glucose)
print(df_result)

}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
