% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{unpivot}
\alias{unpivot}
\alias{unpivot.pivot_table}
\title{Unpivot a pivot table}
\usage{
unpivot(pt, include_page, na_rm, keep_col_names)

\method{unpivot}{pivot_table}(pt, include_page = TRUE, na_rm = TRUE, keep_col_names = FALSE)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{include_page}{A boolean, indicates whether a column with the page
information is included or not.}

\item{na_rm}{A boolean, indicates whether NA values from the array of values
are removed or not.}

\item{keep_col_names}{A boolean, if possible, keep the column names.}
}
\value{
A \code{tibble}.
}
\description{
Transforms a pivot table into a flat table (implemented by a \code{tibble}). An
additional column with page information can be included. NA values can be
excluded from the array of values.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.
}
\examples{

a_tibble <-
  pt_ex |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  unpivot(include_page = FALSE)

a_tibble <-
  pt_ex |>
  set_page(1, 1) |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  remove_k() |>
  replace_dec() |>
  fill_values() |>
  fill_labels() |>
  remove_agg() |>
  unpivot()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()}
}
\concept{pivot table transformation functions}
