% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_html_table}
\alias{read_html_table}
\title{Scrape an online HTML table}
\usage{
read_html_table(url, css)
}
\arguments{
\item{url}{A string giving the URL to read from.}

\item{css}{A string giving the CSS element to select.

SelectorGadget
(\url{https://selectorgadget.com/}) is a useful tool for finding the code for the
CSS element you need. See \code{\link[rvest:html_element]{rvest::html_element()}} for more information.}
}
\value{
A tibble.
}
\description{
\code{read_html_table()} returns an HTML table at a specified URL and CSS element
as a dataframe.
}
\examples{
# The table used in `get_senate_cloture_votes()`
# NOTE: `get_senate_cloture_votes()` performs some cleaning on this table
read_html_table(url = "https://www.senate.gov/legislative/cloture/clotureCounts.htm",
                css = ".cloturecount")

# A table from Baseball Reference
read_html_table(url = "https://www.baseball-reference.com/friv/rules-changes-stats.shtml",
                css = "#time_of_game")
}
