% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{optimMaltipooCollapsed}
\alias{optimMaltipooCollapsed}
\title{Function to Optimize the Collapsed Maltipoo Model}
\usage{
optimMaltipooCollapsed(
  Y,
  upsilon,
  Theta,
  X,
  KInv,
  U,
  init,
  ellinit,
  n_samples = 2000L,
  calcGradHess = TRUE,
  b1 = 0.9,
  b2 = 0.99,
  step_size = 0.003,
  epsilon = 1e-06,
  eps_f = 1e-10,
  eps_g = 1e-04,
  max_iter = 10000L,
  verbose = FALSE,
  verbose_rate = 10L,
  decomp_method = "cholesky",
  eigvalthresh = 0,
  jitter = 0
)
}
\arguments{
\item{Y}{D x N matrix of counts}

\item{upsilon}{(must be > D)}

\item{Theta}{D-1 x Q matrix the prior mean for regression coefficients}

\item{X}{Q x N matrix of covariates}

\item{KInv}{D-1 x D-1 symmetric positive-definite matrix}

\item{U}{a PQxQ matrix of stacked variance components}

\item{init}{D-1 x N matrix of initial guess for eta used for optimization}

\item{ellinit}{P vector of initial guess for ell used for optimization}

\item{n_samples}{number of samples for Laplace Approximation (=0 very fast
as no inversion or decomposition of Hessian is required)}

\item{calcGradHess}{if n_samples=0 should Gradient and Hessian
still be calculated using closed form solutions?}

\item{b1}{(ADAM) 1st moment decay parameter (recommend 0.9) "aka momentum"}

\item{b2}{(ADAM) 2nd moment decay parameter (recommend 0.99 or 0.999)}

\item{step_size}{(ADAM) step size for descent (recommend 0.001-0.003)}

\item{epsilon}{(ADAM) parameter to avoid divide by zero}

\item{eps_f}{(ADAM) normalized function improvement stopping criteria}

\item{eps_g}{(ADAM) normalized gradient magnitude stopping criteria}

\item{max_iter}{(ADAM) maximum number of iterations before stopping}

\item{verbose}{(ADAM) if true will print stats for stopping criteria and
iteration number}

\item{verbose_rate}{(ADAM) rate to print verbose stats to screen}

\item{decomp_method}{decomposition of hessian for Laplace approximation
'eigen' (more stable-slightly, slower) or 'cholesky' (less stable, faster, default)}

\item{eigvalthresh}{threshold for negative eigenvalues in
decomposition of negative inverse hessian (should be <=0)}

\item{jitter}{(default: 0) if >0 then adds that factor to diagonal of Hessian
before decomposition (to improve matrix conditioning)}
}
\value{
List containing (all with respect to found optima)
\enumerate{
\item LogLik - Log Likelihood of collapsed model (up to proportionality constant)
\item Gradient - (if \code{calcGradHess}=true)
\item Hessian - (if \code{calcGradHess}=true) of the POSITIVE log posterior
\item Pars - Parameter value of eta
\item Samples - (D-1) x N x n_samples array containing posterior samples of eta
based on Laplace approximation (if n_samples>0)
\item VCScale - value of e^ell_i at optima
\item logInvNegHessDet - the log determinant of the covariacne of the Laplace
approximation, useful for calculating marginal likelihood
}
}
\description{
See details for model. Should likely be followed by function
\code{\link{uncollapsePibble}}. Notation: \code{N} is number of samples,
\code{D} is number of multinomial categories, and \code{Q} is number
of covariates.
}
\details{
Notation: Let Z_j denote the J-th row of a matrix Z.
Model:
\deqn{Y_j \sim Multinomial(Pi_j)}
\deqn{Pi_j = Phi^{-1}(Eta_j)}
\deqn{Eta \sim T_{D-1, N}(upsilon, Theta*X, K, A)}

Where A = (I_N + e^{ell_1}\emph{X}U_1\emph{X' + ... + e^{ell_P}\emph{X}U_P}X' ),
K is a D-1xD-1 covariance and Phi is ALRInv_D transform.

Gradient and Hessian calculations are fast as they are computed using closed
form solutions. That said, the Hessian matrix can be quite large
[N*(D-1) x N*(D-1)] and storage may be an issue.

Note: Warnings about large negative eigenvalues can either signal
that the optimizer did not reach an optima or (more commonly in my experience)
that the prior / degrees of freedom for the covariance (given by parameters
\code{upsilon} and \code{KInv}) were too specific and at odds with the observed data.
If you get this warning try the following.
\enumerate{
\item Try restarting the optimization using a different initial guess for eta
\item Try decreasing (or even increasing)\code{step_size} (by increments of 0.001 or 0.002)
and increasing \code{max_iter} parameters in optimizer. Also can try
increasing \code{b1} to 0.99 and decreasing \code{eps_f} by a few orders
of magnitude
\item Try relaxing prior assumptions regarding covariance matrix. (e.g., may want
to consider decreasing parameter \code{upsilon} closer to a minimum value of
D)
\item Try adding small amount of jitter (e.g., set \code{jitter=1e-5}) to address
potential floating point errors.
}
}
\references{
S. Ruder (2016) \emph{An overview of gradient descent
optimization algorithms}. arXiv 1609.04747
}
\seealso{
\code{\link{uncollapsePibble}}
}
