% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffAnova.R
\name{ffAnova}
\alias{ffAnova}
\title{Type II* Anova}
\usage{
ffAnova(formula, data = NULL)
}
\arguments{
\item{formula}{A model \code{\link{formula}} or an \code{R} object 
(preferably an \code{\link{lm}} object).}

\item{data}{An optional data frame, list or environment.}
}
\value{
An object of class \code{"anova"} (see \code{\link{anova}}).
}
\description{
Analysis of variance table for a linear model using type \code{II}* sums of squares,
which are described in Langsrud et al. (2007).
Type \code{II}* extends the type \code{II} philosophy to continuous variables. 
The results are invariant to scale changes and pitfalls are avoided.
}
\details{
This function is a variant of \code{\link{ffmanova}} for the univariate special case.
The two input parameters will be interpreted by \code{\link{model.frame}}.
}
\examples{
# Generate example data
set.seed(123)
a <- c(0, 0, 0, 10, 10, 10, 1, 1, 1)
A <- as.character(a)  # A is categorical
b <- 1:9
y <- rnorm(9)/10 + a  # y depends strongly on a (and A)
a100 <- a + 100  # change of scale (origin)
b100 <- b + 100  # change of scale (origin)

# Four ways of obtaining the same results
ffAnova(y ~ A * b)
ffAnova(y ~ A * b100)
ffAnova(lm(y ~ A * b))
ffAnova(y ~ A * b, data.frame(A = A, y = y, b = 1:9))

# Second order continuous variable
ffAnova(y ~ a + I(a^2))

# Model equivalent to 'y ~ A * b'
ffAnova(y ~ (a + I(a^2)) * b)

# Demonstrating similarities and differences using package car
if (!require(car))        # Package car is loaded if available 
  Anova <- function(x) {  # Replacement function if car not available
    warning("No results since package car is not available")}

lm_Ab <- lm(y ~ A * b)
lm_Ab100 <- lm(y ~ A * b100)

# Type II same as type II* in this case
Anova(lm_Ab)      # Type II
Anova(lm_Ab100)   # Type II
ffAnova(lm_Ab)    # Type II*
ffAnova(lm_Ab100) # Type II*

# Type III depends on scale
Anova(lm_Ab, type = 3)
Anova(lm_Ab100, type = 3)

lm_a <- lm(y ~ a + I(a^2))
lm_a100 <- lm(y ~ a100 + I(a100^2))

# Now Type II depends on scale
Anova(lm_a)      # Type II
Anova(lm_a100)   # Type II
ffAnova(lm_a)    # Type II*
ffAnova(lm_a100) # Type II*
}
\references{
Langsrud, Ø., Jørgensen, K., Ofstad, R. and Næs, T. (2007):
 \dQuote{Analyzing Designed Experiments with Multiple Responses},
 \emph{Journal of Applied Statistics}, \bold{34}, 1275-1296.
}
\author{
Øyvind Langsrud and Bjørn-Helge Mevik
}
