% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.feis}
\alias{vcov.feis}
\title{Calculate Variance-Covariance Matrix for a feis object}
\usage{
\method{vcov}{feis}(object, ..., scale = FALSE)
}
\arguments{
\item{object}{an object of class "\code{feis}", fitted model.}

\item{...}{further arguments.}

\item{scale}{logical. If \code{TRUE} returns scaled vcov by sigma^2 (default is \code{FALSE}).}
}
\value{
A matrix of the estimated covariances between the parameter estimates in the fitted FEIS model.
}
\description{
Returns the variance-covariance matrix of the main parameters of an object of class "\code{feis}".
By default, this is the unscaled variance-covariance matrix.
}
\details{
By default, \code{vcov()} return the unscaled variance-covariance matrix of the fitted FEIS model.
If set to \code{scale = TRUE}, the vcov is scaled by the nuisance parameter sigma^2
(as is \code{object$vcov}). Note that corrections for clustering (i.e. \code{robust = TRUE}
in the fitted model) are ignored in \code{vcov()}. In this case, \code{object$vcov} will return
the vcov with corrections for clustering.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry | exp,
                 data = mwp, id = "id")
vcov(feis.mod)

}
\seealso{
\code{\link[feisr]{feis}}, \code{\link[stats]{vcov}}, \code{\link[stats]{sigma}}
}
