% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2gamma}
\alias{norm2gamma}
\title{Convert normal to gamma}
\usage{
norm2gamma(x, shape, rate = 1, scale = 1/rate, mu = mean(x), sd = stats::sd(x))
}
\arguments{
\item{x}{the normally distributed vector}

\item{shape}{gamma distribution parameter (must be positive)}

\item{rate}{an alternative way to specify the scale}

\item{scale}{gamma distribution parameter (must be positive)}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a gamma distribution
}
\description{
Convert normal to gamma
}
\examples{

x <- rnorm(10000)
y <- norm2gamma(x, shape = 2)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
