% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{dlikert}
\alias{dlikert}
\title{Likert density function}
\usage{
dlikert(x, prob, labels = names(prob))
}
\arguments{
\item{x}{the likert distributed vector}

\item{prob}{a vector of probabilities or counts; if named, the output is a factor}

\item{labels}{a vector of values, defaults to names(prob) or 1:length(prob), if numeric, the output is numeric}
}
\value{
a vector of the densities
}
\description{
Likert density function
}
\examples{
x <- 1:5
prob <- c(.1, .2, .4, .2, .1)
dlikert(x, prob)

x <- c("A", "C", "B", "B")
prob <- c(A = 10, B = 20, C = 30)
dlikert(x, prob)

# specify labels if prob not named and not 1:length(prob)
labels <- -2:2 
x <- sample(labels, 10, replace = TRUE)
prob <- rep(1, length(labels)) # uniform probability
dlikert(x, prob, labels)
}
