% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRR_HelperFxns.R
\name{print2}
\alias{print2}
\title{Print timestamped messages with optional quieting}
\usage{
print2(text, quiet = FALSE)
}
\arguments{
\item{text}{A character string containing the message to be printed.}

\item{quiet}{A logical value indicating whether to suppress output. Default is \code{FALSE}.}
}
\value{
No return value, called for side effect of printing with timestamp.
}
\description{
This function prints messages prefixed with the current timestamp in a standardized format.
Messages can be suppressed using the quiet parameter.
}
\details{
The function prepends the current timestamp in "YYYY-MM-DD HH:MM:SS" format
to the provided message.
}
\examples{
# Print a basic message with timestamp
print2("Processing started")

# Suppress output
print2("This won't show", quiet = TRUE)

# Use in a loop
for(i in 1:3) {
  print2(sprintf("Processing item \%d", i))
}

}
\seealso{
\code{Sys.time} for the underlying timestamp functionality.
}
