% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.polygons.r
\name{as.polygons,GRaster-method}
\alias{as.polygons,GRaster-method}
\alias{as.polygons}
\title{Convert a raster to a polygons vector}
\usage{
\S4method{as.polygons}{GRaster}(x, round = TRUE, smooth = FALSE)
}
\arguments{
\item{x}{A \code{GRaster}. If more than one layer is in the \code{GRaster}, only the first will be used (with a warning).}

\item{round}{Logical: If \code{TRUE} (default), values in the raster will be rounded first before conversion to a vector. This causes cells that are adjacent that have the same (rounded) values to be combined into a single polygon. For more control, see \code{\link[=clump]{clump()}}.}

\item{smooth}{Logical: If \code{TRUE}, round the corners of square features. Default is \code{FALSE}.}
}
\value{
A \code{GVector}.
}
\description{
\code{\link[=as.polygons]{as.polygons()}} converts a \code{GRaster} to a "polygons" \code{GVector}. After running this function, \link[=breakPolys]{geometry cleaning} may be useful to use to "tidy up" the vector.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation
madElev <- fastData("madElev")

# Convert SpatRaster to GRaster:
elev <- fast(madElev)

# To speed things up, first group cells of similar value:
elevClumps <- clump(elev, minDiff = 0.0115)

# Convert to polygons:
rastToPolys <- as.polygons(elevClumps)
plot(rastToPolys)

}
}
\seealso{
\code{\link[=as.points]{as.points()}}, \code{\link[=as.lines]{as.lines()}}, \code{\link[terra:as.polygons]{terra::as.polygons()}}, \link[=breakPolys]{geometry cleaning}, and \strong{GRASS} tool \code{r.to.vect}
}
