% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.contour.r
\name{as.contour,GRaster-method}
\alias{as.contour,GRaster-method}
\alias{as.contour}
\title{Contour lines from a "GRaster"}
\usage{
\S4method{as.contour}{GRaster}(x, nlevels, levels)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{nlevels}{Numeric: A positive integer or missing (default). Number of levels at which to calculate contours. Levels will be calculated in equal-sized steps from the smallest to the largest value of \code{x}. Either \code{nlevels} or \code{levels} must be specified.}

\item{levels}{Numeric vector: A numeric vector of values at which to calculate contour lines. Either \code{nlevels} or \code{levels} must be specified.}
}
\value{
A \code{GVector} representing contour lines.
}
\description{
Create a \code{GVector} of contour lines from a \code{GRaster}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# Calculate contour lines:
conts <- as.contour(elev, nlevels = 10)

plot(elev)
plot(conts, add = TRUE)

}
}
\seealso{
\code{\link[terra:contour]{terra::as.contour()}}, \strong{GRASS} manual page for tool \code{r.contour} (see \code{grassHelp("r.contour")})
}
