% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexagons.r
\name{hexagons,GRaster-method}
\alias{hexagons,GRaster-method}
\alias{hexagons}
\alias{hexagons,GVector-method}
\title{Create a hexagonal grid}
\usage{
\S4method{hexagons}{GRaster}(x, ny = 10, expand = 0, angle = 0)

\S4method{hexagons}{GVector}(x, ny = 10, expand = 0, angle = 0)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector}.}

\item{ny}{Integer or numeric integer: Number of rows of hexagons that span the extent of object \code{x}.}

\item{expand}{One or two numeric values: Expand the region by this proportion in both directions (a single value) or in the x- and y-dimensions separately. Expanding the region can be helpful to ensure the entire area of interest is covered by polygons, which can otherwise leave gaps at the edges. The number of rows and columns will be increased, but the number of hexagons that span \code{x} will still be \code{ny}.}

\item{angle}{Numeric: Degrees by which to rotate grid (from north, clockwise).}
}
\value{
A \code{GVector}.
}
\description{
This function creates a \code{GVector} of "wall-to-wall" hexagons. The input can be a \code{GVector} or \code{GRaster}, which provides the extent of the output.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Points vector of specimens of species in the plant genus Dypsis
madCoast0 <- fastData("madCoast0")

# Convert sf to a GVector:
coast <- fast(madCoast0)

### grid

# grid specified by number of cells in x-dimension
g1 <- grid(coast, nx = 10)
plot(coast, col = "cornflowerblue")
plot(g1, add = TRUE)

# grid specified by number of cells in x- and y-dimension
g2 <- grid(coast, nx = 10, ny = 5)
plot(coast, col = "cornflowerblue")
plot(g2, add = TRUE)

# grid specified by size of cells in both dimensions
g3 <- grid(coast, nx = 1250, ny = 2000, use = "size")
plot(coast, col = "cornflowerblue")
plot(g3, add = TRUE)

### hexagons

hexes <- hexagons(coast, ny = 10)
plot(hexes)
plot(coast, lwd = 2, add = TRUE)

hexes <- hexagons(coast, ny = 10, expand = c(0.3, 0.1))
plot(hexes)
plot(coast, lwd = 2, add = TRUE)

}
}
\seealso{
\code{\link[=grid]{grid()}}, module \code{v.mkgrid} in \strong{GRASS}
}
