% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LD.R
\name{LD}
\alias{LD}
\alias{print.LD}
\alias{plot.LD}
\title{Likelihood Distance}
\usage{
LD(data, model, progress = FALSE, ...)

\method{print}{LD}(x, ncases = 10, digits = 5, ...)

\method{plot}{LD}(x, y = NULL, main = "Likelihood Distance", type = c("p",
  "h"), ylab = "LD", absolute = FALSE, ...)
}
\arguments{
\item{data}{matrix or data.frame}

\item{model}{if a single numeric number declares number of factors to extract in
exploratory factor analysis (requires complete dataset, i.e., no missing).
If \code{class(model)} is a sem (semmod), or lavaan (character),
then a confirmatory approach is performed instead. Finally, if the model is defined with
\code{mirt::mirt.model()} then distances will be computed for categorical data with the
mirt package}

\item{progress}{logical; display the progress of the computations in the console?}

\item{...}{additional parameters to be passed}

\item{x}{an object of class \code{LD}}

\item{ncases}{number of extreme cases to display}

\item{digits}{number of digits to round in the printed result}

\item{y}{a \code{NULL} value ignored by the plotting function}

\item{main}{the main title of the plot}

\item{type}{type of plot to use, default displays points and lines}

\item{ylab}{the y label of the plot}

\item{absolute}{logical; use absolute values instead of deviations?}
}
\description{
Compute likelihood distances between models when removing the \eqn{i_{th}} case. If there are no
missing data then the \code{\link{GOF}} will often provide equivalent results. If mirt is used,
then the values will be associated with the unique response patterns instead.
}
\details{
Note that \code{LD} is not limited to confirmatory factor analysis and
can apply to nearly any model being studied
where detection of influential observations is important.
}
\examples{

\dontrun{

#run all LD functions using multiple cores
setCluster()

#Exploratory
nfact <- 3
(LDresult <- LD(holzinger, nfact))
(LDresult.outlier <- LD(holzinger.outlier, nfact))
plot(LDresult)
plot(LDresult.outlier)

## add a progress meter
LDresult <- LD(holzinger, nfact, progress = TRUE)

#-------------------------------------------------------------------
#Confirmatory with sem
model <- sem::specifyModel()
  F1 -> Remndrs,    lam11
	  F1 -> SntComp,    lam21
	  F1 -> WrdMean,    lam31
	  F2 -> MissNum,    lam42
	  F2 -> MxdArit,    lam52
	  F2 -> OddWrds,    lam62
	  F3 -> Boots,      lam73
  F3 -> Gloves,     lam83
	  F3 -> Hatchts,    lam93
	  F1 <-> F1,   NA,     1
	  F2 <-> F2,   NA,     1
	  F3 <-> F3,   NA,     1

(LDresult <- LD(holzinger, model))
(LDresult.outlier <- LD(holzinger.outlier, model))
plot(LDresult)
plot(LDresult.outlier)

#-------------------------------------------------------------------
#Confirmatory with lavaan
model <- 'F1 =~  Remndrs + SntComp + WrdMean
F2 =~ MissNum + MxdArit + OddWrds
F3 =~ Boots + Gloves + Hatchts'

(LDresult <- LD(holzinger, model, orthogonal=TRUE))
(LDresult.outlier <- LD(holzinger.outlier, model, orthogonal=TRUE))
plot(LDresult)
plot(LDresult.outlier)

# categorical data with mirt
library(mirt)
data(LSAT7)
dat <- expand.table(LSAT7)
model <- mirt.model('F = 1-5')
LDresult <- LD(dat, model)
plot(LDresult)

}
}
\references{
Chalmers, R. P. & Flora, D. B. (2015). faoutlier: An R Package for Detecting 
  Influential Cases in Exploratory and Confirmatory Factor Analysis.
  \emph{Applied Psychological Measurement, 39}, 573-574. \doi{10.1177/0146621615597894}

Flora, D. B., LaBrish, C. & Chalmers, R. P. (2012). Old and new ideas for data 
screening and assumption testing for exploratory and confirmatory factor analysis. 
 \emph{Frontiers in Psychology, 3}, 1-21. \doi{10.3389/fpsyg.2012.00055}
}
\seealso{
\code{\link{gCD}}, \code{\link{GOF}}, \code{\link{obs.resid}},
  \code{\link{robustMD}}, \code{\link{setCluster}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{cooks}
