% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual_reg_parc.R
\name{dual_reg_parc}
\alias{dual_reg_parc}
\title{Multiple regression for parcel data}
\usage{
dual_reg_parc(
  BOLD,
  parc,
  parc_vals,
  scale = c("local", "global", "none"),
  scale_sm_xifti = NULL,
  scale_sm_FWHM = 2,
  TR = NULL,
  hpf = 0.01,
  GSR = FALSE
)
}
\arguments{
\item{BOLD}{Subject-level fMRI data matrix (\eqn{V \times T}). Rows will be
centered.}

\item{parc}{The parcellation as an integer vector.}

\item{parc_vals}{The parcel values (keys) in desired order, e.g.
\code{sort(unique(parc))}.}

\item{scale}{\code{"local"} (default), \code{"global"}, or \code{"none"}.
Local scaling will divide each data location's time series by its estimated
standard deviation. Global scaling will divide the entire data matrix by the
mean image standard deviation (\code{mean(sqrt(rowVars(BOLD)))}).}

\item{scale_sm_xifti, scale_sm_FWHM}{Only applies if \code{scale=="local"} and
\code{BOLD} represents CIFTI-format data. To smooth the standard deviation
estimates used for local scaling, provide a \code{"xifti"} object with data
locations in alignment with \code{BOLD}, as well as the smoothing FWHM
(default: \code{2}). If no \code{"xifti"} object is provided (default), do
not smooth.}

\item{TR}{The temporal resolution of the data, i.e. the time between volumes,
in seconds. \code{TR} is required for detrending with \code{hpf}.}

\item{hpf}{The frequency at which to apply a highpass filter to the data
during pre-processing, in Hertz. Default: \code{0.01} Hertz. Set to \code{0}
to disable the highpass filter.

The highpass filter serves to detrend the data, since low-frequency
variance is associated with noise. Highpass filtering is accomplished by
nuisance regression of discrete cosine transform (DCT) bases.

Note the \code{TR} argument is required for highpass filtering. If
\code{TR} is not provided, \code{hpf} will be ignored.}

\item{GSR}{Center BOLD across columns (each image)? This
is equivalent to performing global signal regression. Default:
\code{FALSE}.}
}
\value{
A list containing
the subject-level independent components \strong{S} (\eqn{Q \times V}),
and subject-level mixing matrix \strong{A} (\eqn{TxQ}).
}
\description{
Multiple regression for parcel data
}
