% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_fun.R
\name{window_fun}
\alias{window_fun}
\title{Function over grouping variables (window function)}
\usage{
window_fun(x, ...)
}
\arguments{
\item{x}{A vector}

\item{...}{Grouping variables all of the same length as x or length 1 and
function as last argument.}
}
\value{
vector of the same length as \code{x}
}
\description{
This is faster version of \link[stats]{ave}. \code{window_fun} applies function
to every subset of \code{x} and return vector of the same length as \code{x}.
}
\examples{
window_fun(1:3, mean)  # no grouping -> grand mean

attach(warpbreaks)

window_fun(breaks, wool, mean)
window_fun(breaks, tension, function(x) mean(x, trim = 0.1))

detach(warpbreaks)
}
