% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepend_names.R
\name{prepend_values}
\alias{prepend_values}
\alias{prepend_names}
\alias{prepend_all}
\alias{tab_prepend_values}
\alias{tab_prepend_names}
\alias{tab_prepend_all}
\title{Prepend values/variable names to value/variable labels}
\usage{
prepend_values(x)

prepend_names(x)

prepend_all(x)

tab_prepend_values(data)

tab_prepend_names(data)

tab_prepend_all(data)
}
\arguments{
\item{x}{vector/data.frame. \code{prepend_names} can be applied only to data.frames.}

\item{data}{data.frame/intermediate result of tables construction. See \link{tables}.}
}
\value{
original object with prepended names/values to labels
}
\description{
These functions add values/variable names as prefixes to value/variable 
labels. Functions which start with \code{tab_} intended for usage inside 
table creation sequences. See examples and \link{tables}. It is recommended
to use \code{tab_prepend_*} at the start of sequence of tables creation. If
you use it in the middle of the sequence then previous statements will not be
affected.
}
\examples{
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (lb/1000)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

# prepend names and 'cro_cpct'
mtcars \%>\% 
       prepend_names \%>\% 
       calculate(
              cro_cpct(list(cyl, gear), list(total(), vs, am))
           )
     
# prepend values to value labels                 
mtcars \%>\% 
   tab_prepend_values \%>\% 
   tab_cols(total(), vs, am) \%>\% 
   tab_cells(cyl, gear) \%>\% 
   tab_stat_cpct() \%>\% 
   tab_pivot()

# prepend names and labels
mtcars \%>\% 
   tab_prepend_all \%>\% 
   tab_cols(total(), vs, am) \%>\% 
   tab_cells(cyl, gear) \%>\% 
   tab_stat_cpct() \%>\% 
   tab_pivot() 
   
# variable in rows without prefixes
mtcars \%>\% 
   tab_cells(cyl, gear) \%>\% 
   tab_prepend_all \%>\% 
   tab_cols(total(), vs, am) \%>\% 
   tab_stat_cpct() \%>\% 
   tab_pivot()   
}
