% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psa.plot.R
\name{psa.plot}
\alias{psa.plot}
\title{Graphical depiction of the probabilistic sensitivity analysis for the
survival curves - ported from \code{survHE}}
\usage{
psa.plot(psa, ...)
}
\arguments{
\item{psa}{the result of the call to the function \code{make.surv}}

\item{...}{Optional graphical parameters, such as: \code{xlab} = label for
the x-axis \code{ylab} = label for the y-axis \code{col} = (vector) of
colors for the lines to be plotted \code{alpha} = the level of transparency
for the curves (default = 0.2)}
}
\value{
ggplot2 object of the survival curve including parameter uncertainty
}
\description{
Plots the survival curves for all the PSA simulations. The function is
actually deprecated - similar graphs can be obtained directly using
the \code{plot} method (with options), which allows a finer depiction
of the results.
}
\examples{
require("dplyr")
param_expert_example1 <- list()
param_expert_example1[[1]] <- data.frame(dist = c("norm","t"),
                                        wi = c(0.5,0.5), # Ensure Weights sum to 1
                                        param1 = c(0.1,0.12),
                                        param2 = c(0.15,0.5),
                                        param3 = c(NA,3))

timepoint_expert <- 14
data2 <- data \%>\% rename(status = censored) \%>\% mutate(time2 = ifelse(time > 10, 10, time),
                                                      status2 = ifelse(time> 10, 0, status))
example1 <- fit.models.expert(formula=Surv(time2,status2)~1,data=data2,
                             distr=c("wph", "gomp"),
                             method="mle",
                             pool_type = "log pool",
                             opinion_type = "survival",
                             times_expert = timepoint_expert,
                             param_expert = param_expert_example1)

p.mle = make.surv(example1,mod= 2,t = 1:30, nsim=1000) #Plot the Gompertz model
psa.plot(p.mle , name_labs = "PSA", labs = "Gompertz", col ="blue")

}
\references{
\insertRef{Baio.2020}{expertsurv}
}
\author{
Gianluca Baio
}
\keyword{Bootstrap}
\keyword{Probabilistic}
\keyword{Survival}
\keyword{analysis}
\keyword{models}
\keyword{sensitivity}
