% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{tetrachoric}
\alias{tetrachoric}
\title{Tetrachoric Correlation}
\usage{
tetrachoric(x, y)
}
\arguments{
\item{x}{binary vector x}

\item{y}{binary vector y}
}
\value{
Returns a single numeric value of class "exametrika" representing the
tetrachoric correlation coefficient between the two binary variables. The value
ranges from -1 to 1, where:
\itemize{
\item 1 indicates perfect positive correlation
\item -1 indicates perfect negative correlation
\item 0 indicates no correlation
}
}
\description{
Tetrachoric Correlation is superior to the phi coefficient as a measure of the
relation of an item pair. See Divgi, 1979; Olsson, 1979;Harris, 1988.
}
\references{
Divgi, D. R. (1979). Calculation of the tetrachoric correlation coefficient.
Psychometrika, 44, 169–172.

Olsson, U. (1979). Maximum likelihood estimation of the polychoric correlation
coefficient. Psychometrika,44, 443–460.

Harris, B. (1988). Tetrachoric correlation coefficient. In L. Kotz, & N. L. Johnson
(Eds.), Encyclopedia of statistical sciences (Vol. 9, pp. 223–225). Wiley.
}
