% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mdiff_paired.R
\name{estimate_mdiff_paired}
\alias{estimate_mdiff_paired}
\title{Estimates for a repeated-measures study with two measures of a continuous
variable}
\usage{
estimate_mdiff_paired(
  data = NULL,
  comparison_measure = NULL,
  reference_measure = NULL,
  comparison_mean = NULL,
  comparison_sd = NULL,
  reference_mean = NULL,
  reference_sd = NULL,
  n = NULL,
  correlation = NULL,
  comparison_measure_name = "Comparison measure",
  reference_measure_name = "Reference measure",
  conf_level = 0.95,
  save_raw_data = TRUE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{comparison_measure}{For raw data - The column name of comparison
measure of the outcome variable, or a vector of numeric data}

\item{reference_measure}{For raw data - The column name of the reference
measure of the outcome variable, or a vector of numeric data}

\item{comparison_mean}{For summary data, a numeric}

\item{comparison_sd}{For summary data, numeric > 0}

\item{reference_mean}{For summary data, a numeric}

\item{reference_sd}{For summary data, numeric > 0}

\item{n}{For summary data, a numeric integer > 0}

\item{correlation}{For summary data, correlation between measures, a numeric
that is > -1 and < 1}

\item{comparison_measure_name}{For summary data - An optional character
label for the comparison measure.  Defaults to 'Comparison measure'}

\item{reference_measure_name}{For summary data - An optional character
label for the reference measure.  Defaults to 'Reference measure'}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{save_raw_data}{For raw data; defaults to TRUE; set to FALSE to save
memory by not returning raw data in estimate object}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
\item \strong{es_mean_difference}
\itemize{
\item \emph{type} -
\item \emph{comparison_measure_name} -
\item \emph{reference_measure_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_smd}
\itemize{
\item \emph{comparison_measure_name} -
\item \emph{reference_measure_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{numerator} -
\item \emph{denominator} -
\item \emph{SE} -
\item \emph{d_biased} -
\item \emph{df} -
}
\item \strong{es_r}
\itemize{
\item \emph{x_variable_name} -
\item \emph{y_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{n} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_median_difference}
\itemize{
\item \emph{type} -
\item \emph{comparison_measure_name} -
\item \emph{reference_measure_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_mean_ratio}
\itemize{
\item \emph{comparison_measure_name} -
\item \emph{reference_measure_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{comparison_mean} -
\item \emph{reference_mean} -
}
\item \strong{es_median_ratio}
\itemize{
\item \emph{comparison_measure_name} -
\item \emph{reference_measure_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{comparison_median} -
\item \emph{reference_median} -
}
\item \strong{raw_data}
\itemize{
\item \emph{comparison_measure} -
\item \emph{reference_measure} -
}
}
}
\description{
Returns object
\code{estimate_mdiff_paired} is suitable for a simple paired design
with a continuous outcome variable.  It provides estimates and CIs for the
population mean difference between the repeated measures, the standardized
mean difference (SMD; Cohen's d) between the repeated measures, and the
median difference between the repeated measures (raw data only).  You can
pass raw data or summary data.
}
\details{
Reach for this function in place of a paired-samples \emph{t}-test.

Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_mdiff]{plot_mdiff()}} and you can test hypotheses with
\code{\link[=test_mdiff]{test_mdiff()}}.

The estimated mean differences are from \code{\link[statpsych:ci.mean.ps]{statpsych::ci.mean.ps()}}.

The estimated SMDs are from \code{\link[=CI_smd_ind_contrast]{CI_smd_ind_contrast()}}.

The estimated median differences are from \code{\link[statpsych:ci.median.ps]{statpsych::ci.median.ps()}}.
}
\examples{
# From raw data
data("data_thomason_1")

estimate_from_raw <- esci::estimate_mdiff_paired(
  data = esci::data_thomason_1,
  comparison_measure = Posttest,
  reference_measure = Pretest
)

# To visualize the estimated median difference (raw data only)
myplot_from_raw <- esci::plot_mdiff(estimate_from_raw, effect_size = "median")

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_mdiff(
  estimate_from_raw,
  effect_size = "median",
  rope = c(-2, 2)
)


sd1 <- 4.28
sd2 <- 3.4
sdiff <- 2.13

cor <- (sd1^2 + sd2^2 - sdiff^2) / (2*sd1*sd2)

estimate_from_summary <- esci::estimate_mdiff_paired(
  comparison_mean = 14.25,
  comparison_sd = 4.28,
  reference_mean = 12.88,
  reference_sd = 3.4,
  n = 16,
  correlation = 0.87072223749,
  comparison_measure_name = "After",
  reference_measure_name = "Before"
)

# To visualize the estimated mean difference
myplot_from_summary <- esci::plot_mdiff(
  estimate_from_summary,
  effect_size = "mean"
)

# To conduct a hypothesis test
res_htest_from_summary <- esci::test_mdiff(
  estimate_from_summary,
  effect_size = "mean",
  rope = c(-2, 2)
)


}
