% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crystallised_dose_paths.R
\name{crystallised_dose_paths}
\alias{crystallised_dose_paths}
\title{Dose-paths with probabilities attached.}
\usage{
crystallised_dose_paths(
  dose_paths,
  true_prob_tox,
  true_prob_eff = NULL,
  terminal_nodes
)
}
\arguments{
\item{dose_paths}{Object of type \code{\link{dose_paths}}}

\item{true_prob_tox}{vector of toxicity probabilities at doses 1..n}

\item{true_prob_eff}{vector of efficacy probabilities at doses 1..n,
optionally NULL if efficacy not evaluated.}

\item{terminal_nodes}{tibble of terminal nodes on the dose-paths}
}
\value{
An object of type crystallised_dose_paths
}
\description{
\code{\link{dose_paths}} reflect all possible paths a dose-finding trial may
take. When the probability of those paths is calculated using an assumed set
of true dose-event probabilities, in this package those paths are said to be
crysallised. Once crystallised, operating charactersitics can be calculated.
}
\examples{
# Calculate dose paths for the first three cohorts in a 3+3 trial of 5 doses:
paths <- get_three_plus_three(num_doses = 5) \%>\%
  get_dose_paths(cohort_sizes = c(3, 3, 3))

# Set the true probabilities of toxicity
true_prob_tox <- c(0.12, 0.27, 0.44, 0.53, 0.57)
# Crytallise the paths with the probabilities of toxicity
x <- paths \%>\% calculate_probabilities(true_prob_tox)
# And then examine, for example, the probabilities of recommending each dose
# at the terminal nodes of these paths:
prob_recommend(x)
}
