% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rep.errors}
\alias{rep.errors}
\title{Replicate Elements of Vectors and Lists}
\usage{
\method{rep}{errors}(x, ...)
}
\arguments{
\item{x}{a vector (of any mode including a \code{\link[base]{list}}) or a factor or (for
    \code{rep} only) a \code{POSIXct} or \code{POSIXlt} or \code{Date}
    object; or an S4 object containing such an object.}

\item{...}{further arguments to be passed to or from other methods.
    For the internal default method these can include:
    \describe{
      \item{\code{times}}{an integer-valued vector giving the
	(non-negative) number of times to repeat each element if of
	length \code{length(x)}, or to repeat the whole vector if of
	length 1.  Negative or \code{NA} values are an error.  A
	\code{double} vector is accepted, other inputs being coerced to
	an integer or double vector.}
      \item{\code{length.out}}{non-negative integer.  The desired length of the
        output vector.  Other inputs will be coerced to a double
	vector and the first element taken.  Ignored if \code{NA} or invalid.}
      \item{\code{each}}{non-negative integer.  Each element of \code{x}
	is repeated \code{each} times.  Other inputs will be coerced to
	an integer or double vector and the first element taken.  Treated as
	\code{1} if \code{NA} or invalid.}
    }
  }
}
\description{
S3 method for \code{errors} objects (see \code{\link{rep}}).
}
\examples{
rep(set_errors(1, 0.1), 4)

}
