% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{NetworkSIR}
\alias{NetworkSIR}
\alias{netSIR}
\title{Function to simulate an epidemic on a network}
\usage{
NetworkSIR(CM, tau, gamma)
}
\arguments{
\item{CM}{a contact matrix}

\item{tau}{the transmission probabiliy}

\item{gamma}{the recovery probabiliy}
}
\value{
An object of class netSIR with infectious status for each node through time
}
\description{
Function to simulate a stochastic (discrete time) Reed-Frost SIR model on a social network
}
\examples{
cm1=BarabasiAlbert(N=200,K=2)
sim1=NetworkSIR(cm1,.3,0.1)
summary(sim1)
\dontrun{plot(sim1)}
}
