% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeterogeneityNests.R
\name{HeterogeneityNests}
\alias{HeterogeneityNests}
\title{Model heterogeneity of temperatures.}
\usage{
HeterogeneityNests(
  nests = stop("An object of class Nests2, NestsResult, or mcmcComposite."),
  probs = c(0.025, 0.975),
  control.legend.total = list(),
  control.legend.metabolicheating = list(),
  show.full.incubation = TRUE,
  show.first.half.incubation = TRUE,
  col.absolute.difference.full = rgb(blue = 0.1, green = 0.1, red = 1, alpha = 0.01),
  pch.absolute.difference.full = 19,
  col.absolute.difference.first = rgb(blue = 1, green = 0.1, red = 0.1, alpha = 0.01),
  pch.absolute.difference.first = 19,
  show.se = TRUE,
  show.sd = TRUE,
  n.iter = 10000,
  n.adapt = 1000,
  thin = 5,
  adaptive = TRUE,
  return.mcmc = FALSE,
  trace = FALSE,
  rules = rbind(data.frame(Name = "min", Min = 0, Max = 2), data.frame(Name = "max", Min
    = 0, Max = 20), data.frame(Name = "S", Min = 0, Max = 10), data.frame(Name = "P", Min
    = 0, Max = 50), data.frame(Name = "asd", Min = 0, Max = 2), data.frame(Name = "bsd",
    Min = 0, Max = 1)),
  fitted.parameters = c(min = 1, max = 3.95, S = 0.62, P = 5.7, asd = 0.014, bsd = 1.19),
  fixed.parameters = NULL,
  ...
)
}
\arguments{
\item{nests}{An object of class Nests, Nests2, NestsResult, or mcmcComposite.}

\item{probs}{A vector of two values to set the range of quantiles to define heterogeneity. Use 0 and 1 for min and max.}

\item{control.legend.total}{A list of options for legend.}

\item{control.legend.metabolicheating}{A list of options for legend.}

\item{show.full.incubation}{Show the plot with full incubation?}

\item{show.first.half.incubation}{Show the plot with first half incubation?}

\item{col.absolute.difference.full}{The color for absolute difference of temperatures for full incubation.}

\item{pch.absolute.difference.full}{The pch for absolute difference of temperatures for full incubation.}

\item{col.absolute.difference.first}{The color for absolute difference of temperatures for first-half incubation.}

\item{pch.absolute.difference.first}{The pch for absolute difference of temperatures for first-half incubation.}

\item{show.se}{The standard error of the modelled heterogeneity.}

\item{show.sd}{The standard deviation of the observed heterogeneity.}

\item{n.iter}{Number of iteration for MCMC}

\item{n.adapt}{Number of adaptation for MCMC}

\item{thin}{Number of thin for MCMC}

\item{adaptive}{Do adaptive MCMC should be used}

\item{return.mcmc}{Should the mcmc object be returned?}

\item{trace}{Show intermediate results.}

\item{rules}{The rules for max and min for each parameters.}

\item{fitted.parameters}{The set of fitted parameters with plausible values based on rules.}

\item{fixed.parameters}{The values of parameters that will not be changed during optimisation.}

\item{...}{Parameters used for plot.}
}
\value{
Nothing.
}
\description{
Generate a model of heterogeneity of temperatures.\cr
}
\details{
HeterogeneityNests models heterogeneity of temperatures.
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
Laying.Time <- matrix(c("DY.1", "15/05/2010", 
                 "DY.17", "24/05/2010", 
                 "DY.16", "24/05/2010", 
                 "DY.18", "25/05/2010", 
                 "DY.20", "25/05/2010", 
                 "DY.21", "26/05/2010", 
                 "DY.22", "26/05/2010", 
                 "DY.23", "26/05/2010", 
                 "DY.24", "27/05/2010", 
                 "DY.25", "27/05/2010", 
                 "DY.28", "28/05/2010", 
                 "DY.26", "28/05/2010", 
                 "DY.27", "28/05/2010", 
                 "DY.146", "20/06/2010", 
                 "DY.147", "20/06/2010", 
                 "DY.172", "24/06/2010", 
                 "DY.175", "24/06/2010", 
                 "DY.170", "24/06/2010", 
                 "DY.260", "06/07/2010", 
                 "DY.282", "12/07/2010", 
                 "DY.310", "18/07/2010", 
                 "DY.309", "18/07/2010", 
                 "DY.328", "25/07/2010", 
                 "DY.331", "26/07/2010"), byrow=TRUE, ncol=2)
tz <- OlsonNames()[grepl("Asia/Istanbul", OlsonNames())]
Laying.Time_f <- as.POSIXlt.character(Laying.Time[, 2], format = "\%d/\%m/\%Y", tz=tz)
names(Laying.Time_f) <- Laying.Time[, 1]
nests <- FormatNests(data=nest, previous=NULL, col.Time="Time", 
                      LayingTime=Laying.Time_f, simplify=FALSE)
HeterogeneityNests(nests, ylim=c(0, 30))
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
