% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.egonet.R
\name{onefile_to_egor}
\alias{onefile_to_egor}
\title{Import ego-centered network data from 'one file format'}
\usage{
onefile_to_egor(
  egos,
  netsize = NULL,
  ID.vars = list(ego = "egoID"),
  attr.start.col,
  attr.end.col,
  max.alters,
  aa.first.var,
  aa.regex = NULL,
  var.wise = FALSE,
  ...
)
}
\arguments{
\item{egos}{\code{Data frame} containing ego data (egos as cases)}

\item{netsize}{Numeric, network size values are used to filter out empty
alter entries. If the alter data is not structured in a way, where valid alters
are stored before the invalid alters, pass NULL here and filter out invalid
alters afterwards.}

\item{ID.vars}{Character. For onefile_to_egor only the name of the ego ID needs
to be provided.}

\item{attr.start.col}{Index or name of the first column containing alter attributes.}

\item{attr.end.col}{Index or name of the last column containing alter attributes.}

\item{max.alters}{Maximum number of alters.}

\item{aa.first.var}{First column containing alter-alter relations/ edges.}

\item{aa.regex}{A Perl regular expression with name capture,
intended to be run on column names and capturing via named
capture the following regex groups: \code{"attr"}, \code{"src"}, and
\code{"tgt"}, representing the edge attribute being captured, the
source (or the first alter identified), and the target (or the
second alter identified) of the edge, respectively. See \code{\link{regex}}
for more information.}

\item{var.wise}{Logical value indicating if the alter attributes are sorted variable wise (defaults to FALSE).}

\item{...}{additional arguments to \code{\link[=egor]{egor()}}.}
}
\value{
An \strong{egor} object is returned. It is a \code{list} of three data frames:
(1) ego: \code{dataframe} of all
egos and their attributes;
(2) alter: \code{dataframe} of all alters;
(3) aatie: \code{dataframe} of alter alter ties/ edges
}
\description{
This function imports ego-centered network data, stored in a single file, providing
ego, alter and edge data. This data format is used by the Allbus 2010 (GESIS)
and similar social surveys.
}
\examples{
path_to_one_file_8 <- system.file("extdata", "one_file_8.csv", package = "egor")
egos_8 <- read.csv2(path_to_one_file_8)

onefile_to_egor(
  egos = egos_8, netsize = egos_8$netsize,
  attr.start.col = "alter.sex.1",
  attr.end.col = "alter.age.8",
  aa.first.var = "X1.to.2",
  max.alters = 8)
}
\references{
Muller, C., Wellman, B., & Marin, A. (1999). How to Use SPSS to
Study Ego-Centered Networks. Bulletin de Methodologie Sociologique,
64(1), 83-100.
}
\keyword{import}
