library(testthat)

test_that("editmatrix works correcly with editrules",{
   cond <- c( "x == y"
            , "z + w == y + x"
			, "x + z == y + 2*w"
			)
			
   mat <- editmatrix(editrules=cond)
   #print(mat)
   expect_equal(as.integer(mat[1,]), c(1,-1,0,0))
   expect_equal(as.integer(mat[2,]), c(-1,-1,1,1))
   expect_equal(as.integer(mat[3,]), c(1,-1,1,-2))
})

test_that("editmatrix works correcly with editsinfo",{
   
   edtinf.csv <- 
"name,edit
A,x == y
B,z + w == y + x
C,z == y + 2*w
"
   edtinf <- read.csv(textConnection(edtinf.csv))
			
   mat <- editmatrix(edtinf)
   #print(mat)
   expect_equal(as.integer(mat[1,]), c(1,-1,0,0))
   expect_equal(as.integer(mat[2,]), c(-1,-1,1,1))
   expect_equal(as.integer(mat[3,]), c(0,-1,1,-2))
})


test_that("is.editmatrix works",{
   mat <- editmatrix(editrules="x==y")
   expect_true(is.editmatrix(mat))
   expect_false(is.editmatrix(unclass(mat)))
})

test_that("editsinfo returns attribute",{
   mat <- editmatrix(editrules="x==y")
   expect_equal(editsinfo(mat), attr(mat, "editsinfo"))
})

test_that("editsinfo can derive the correct info from a matrix",{
   mat <- matrix( c( 1,-2, 0
                   , 2, 0, 1
				   )
				, nrow=2
				, byrow=2
	#			, dimnames=list(c("a", "b"), c("x","y", "z"))
				)
   #print(editsinfo(mat))
})