% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{-- Introduction --}
\alias{-- Introduction --}
\title{echarty}
\description{
echarty
}
\details{
\subsection{Description}{

\strong{echarty} provides a lean interface between R and Javascript library
\href{https://echarts.apache.org/en/index.html}{ECharts}.
We encourage users to follow the original ECharts \href{https://echarts.apache.org/en/option.html}{API documentation} to construct
charts with echarty.
Main command \strong{ec.init} can set multiple native ECharts options to
build a chart.
The benefits - learn a very limited set of commands, and enjoy the
\strong{full functionality} of ECharts.
}

\subsection{Package Conventions}{

pipe-friendly - supports both \%>\% and |>
commands have three prefixes to help with auto-completion:
\itemize{
\item \strong{ec.} for general functions, like \emph{ec.init}
\item \strong{ecs.} for Shiny functions, like \emph{ecs.output}
\item \strong{ecr.} for rendering functions, like \emph{ecr.band}
}
}

\subsection{Events}{

For event handling in Shiny see sample code in
\href{https://github.com/helgasoft/echarty/blob/main/demo/eshiny.R}{eshiny.R},
run as \code{demo(eshiny)}.
Echarty has three built-in event callbacks - \emph{click}, \emph{mouseover},
\emph{mouseout}. All other ECharts
\href{https://echarts.apache.org/en/api.html#events}{events} could be
initialized through \code{p$x$capture}. Another option is to use \code{p$x$on}
with JavaScript handlers, see code in
\href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{examples}.
}

\subsection{Widget \strong{x} parameters}{

These are \emph{htmlwidget} and \emph{ECharts} initialization parameters supported
by echarty. There are code samples for most of them in
\href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{examples}:
\itemize{
\item capture = event name(s), to monitor events, usually in Shiny
\item on = define JavaScript code for event handling, see
\href{https://echarts.apache.org/en/api.html#echartsInstance.on}{ECharts}
\item registerMap = define a map from a geoJSON file, see
\href{https://echarts.apache.org/en/api.html#echartsInstance.registerMap}{ECharts}
\item group = group-name of a chart, see
\href{https://echarts.apache.org/en/api.html#echartsInstance.group}{ECharts}
\item connect = command to connect charts with same group-name, see
\href{https://echarts.apache.org/en/api.html#echarts.connect}{ECharts}
\item locale = EN(default) or ZH, set from \emph{locale} parameter of \emph{ec.init},
see \href{https://echarts.apache.org/en/api.html#echarts.init}{ECharts}.
\item renderer = \emph{canvas}(default) or \emph{svg}, set from \emph{renderer} in
\emph{ec.init}, see
\href{https://echarts.apache.org/en/api.html#echarts.init}{ECharts}.
\item jcode = custom JavaScript code to execute, set from \emph{js} parameter of
\emph{ec.init}
}
}

\subsection{R vs Javascript numbering}{

R language counting starts from 1.
Javascript (JS) counting starts from 0.
\emph{ec.init} supports R-counting of indexes (ex. encode) and dimension (ex.
visualMap).
\emph{ec.upd} requires indexes and dimensions to be set with JS-counting.
}

\subsection{Javascript built-in functions}{

To allow access to charts from JS.
\emph{ec_chart(id)} - get the chart object by id (former get_e_charts)
\emph{ec_option(id)} - get the chart’s option object by id (former
get_e_charts_opt)
Parameter \emph{id} could be the internal variable \emph{echwid}, or the value set
through \emph{ec.init} parameter \emph{elementId}. See demo code in
\href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{examples}
}

\subsection{Code examples}{

Here is the complete list of sample code \strong{locations}:
\itemize{
\item website
\href{https://helgasoft.github.io/echarty/articles/gallery.html}{gallery}
\item \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{demo examples}
\item Shiny code is in
\href{https://github.com/helgasoft/echarty/blob/main/demo/eshiny.R}{eshiny.R},
run with \code{demo(eshiny)}
\item demos on \href{https://rpubs.com/echarty}{RPubs}
\item searchable \href{https://gist.github.com/helgasoft}{gists}
\item answers to \href{https://github.com/helgasoft/echarty/issues}{Github issues}
\item code in \href{https://github.com/helgasoft/echarty/tree/main/tests/testthat}{Github tests}
\item command examples, like in \emph{?ec.init}
}
}

\subsection{Global Options}{

Options are set with R command
\href{https://www.rdocumentation.org/packages/base/versions/3.6.2/topics/options}{options}.
Echarty uses the following options:
\itemize{
\item echarty.theme = name of theme file, without extension, from folder
\verb{/inst/themes}
\item echarty.font = font family name
\item echarty.urlTiles = tiles URL template for leaflet maps
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# set/get global options
options('echarty.theme'='jazz') # set
getOption('echarty.theme')      # get
#> [1] "jazz"
options('echarty.theme'=NULL)   # remove
}\if{html}{\out{</div>}}
}
}
