% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_create.R
\name{ebv_create}
\alias{ebv_create}
\title{Create an EBV netCDF}
\usage{
ebv_create(
  jsonpath,
  outputpath,
  entities,
  epsg = 4326,
  extent = c(-180, 180, -90, 90),
  resolution = c(1, 1),
  timesteps = NULL,
  fillvalue,
  prec = "double",
  sep = ",",
  force_4D = TRUE,
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{jsonpath}{Character. Path to the json file downloaded from the EBV Data
Portal. Login to the page and click on 'Uploads' and 'New Upload' to start
the process.}

\item{outputpath}{Character. Set path where the netCDF file should be
created.}

\item{entities}{Character string or vector of character strings. In case of
single character string: Path to the csv table holding the entity names.
Default: comma-separated delimiter, else change the \code{sep} argument
accordingly. Should have only one column, each row is the name of one
entity. In case of vector of character strings: Vector holding the entity
names.}

\item{epsg}{Integer. Default: 4326 (WGS84). Defines the coordinate reference
system via the corresponding epsg code.}

\item{extent}{Numeric. Default: c(-180,180,-90,90). Defines the extent of the
data: c(xmin, xmax, ymin, ymax).}

\item{resolution}{Numerical. Vector of two numerical values defining the
longitudinal and latitudinal resolution of the pixel: c(lon,lat).}

\item{timesteps}{Character. Vector of the timesteps in the dataset. Default:
NULL - in this case the time will be calculated from the start-, endpoint
and temporal resolution given in the metadata file (json). Else, the dates
must be given in in ISO format 'YYYY-MM-DD' or shortened 'YYYY' in case of
yearly timesteps.}

\item{fillvalue}{Numeric. Value of the missing data (NoData value) in the
array. Has to be a single numeric value or NA.}

\item{prec}{Character. Default: 'double'. Precision of the data set. Valid
options: 'short' 'integer' 'float' 'double' 'char' 'byte'.}

\item{sep}{Character. Default: ','. If the delimiter of the csv specifying
the entity-names differs from the default, indicate here.}

\item{force_4D}{Logical. Default is TRUE. If the argument is TRUE, there will
be 4D cubes (lon, lat, time, entity) per metric. If this argument is
changed to FALSE, there will be 3D cubes (lon, lat, time) per entity (per
metric). So the latter yields a higher amount of cubes and does not bundle
all information per metric. In the future the standard will be restricted
to the 4D version. Recommendation: go with the 4D cubes!}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE to overwrite the output
file defined by 'outputpath'.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Creates the netCDF file at the 'outputpath' location.
}
\description{
Create the core structure of the EBV netCDF based on the json
from the \href{https://portal.geobon.org}{EBV Data Portal}. Data will be
added afterwards using \code{\link[=ebv_add_data]{ebv_add_data()}}.
}
\note{
To check out the results take a look at your netCDF file with
\href{https://www.giss.nasa.gov/tools/panoply/}{Panoply} provided by the
NASA.
}
\examples{
#set path to JSON file
json <- system.file(file.path("extdata","metadata.json"), package="ebvcube")
#set output path of the new EBV netCDF
out <- file.path(system.file(package='ebvcube'),"extdata","sCAR_new.nc")
#set path to the csv holding the entity names
entities <- file.path(system.file(package='ebvcube'),"extdata","entities.csv")

#create new EBV netCDF
\dontrun{
ebv_create(jsonpath = json, outputpath = out, entities = entities,
           fillvalue=-3.4E38)
}
}
