% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReplaceDimList.R
\name{ReplaceDimList}
\alias{ReplaceDimList}
\title{ReplaceDimList}
\usage{
ReplaceDimList(dimList, replaceList, total = "Total")
}
\arguments{
\item{dimList}{Named list of data frames (sdcTable coded)}

\item{replaceList}{Named list where elements are data frames (sdcTable coded) or character vectors (TauArgus coded)}

\item{total}{String used to name totals when TauArgus coded input}
}
\value{
Updated dimList where some or all elements are replaced
}
\description{
Replace list elements of sdcTable coded hierarchies.
Replacement elements can be sdcTable coded or TauArgus coded.
}
\examples{
# First generate dimLists
dimListA <- FindDimLists(SSBtoolsData("sprt_emp_withEU")[, c("geo", "eu", "age")])
dimListB <- FindDimLists(SSBtoolsData("sprt_emp_withEU")[, c("geo", "age")])
dimListC <- FindDimLists(SSBtoolsData("sprt_emp_withEU")[, c("geo", "eu")])

# dimListA1 and dimListA are identical
dimListA1 <- ReplaceDimList(dimListB, dimListC)
identical(dimListA, dimListA1)

# replaceList can be TauArgus coded
hcrC <- DimList2Hrc(dimListC)

# dimListA2 and dimListA are identical
dimListA2 <- ReplaceDimList(dimListB, hcrC)
identical(dimListA, dimListA2)

# Also possible when duplicated names
ReplaceDimList(FindDimLists(EasyData("z3")[, -7]), 
               FindDimLists(EasyData("z2")[, -5]))
}
\keyword{internal}
