% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core3D.R
\name{sim.uncond.3d}
\alias{sim.uncond.3d}
\title{Unconditional Empirical Random Walk (UERW) in 3-D}
\usage{
sim.uncond.3d(n.locs, start = c(0, 0, 0), a0, g0, densities, error = TRUE)
}
\arguments{
\item{n.locs}{the number of locations for the simulated track}

\item{start}{vector indicating the start point \code{c(x,y,z)}}

\item{a0}{initial heading in radian}

\item{g0}{initial gradient/polar angle in radian}

\item{densities}{list object returned by the \link[eRTG3D]{get.densities.3d} function}

\item{error}{logical: add random noise to the turn angle, lift angle and step length to account for errors measurements?}
}
\value{
A 3 dimensional trajectory in the form of a data.frame
}
\description{
This function creates unconditional walks with prescribed
empirical properties (turning angle, lift angle and step length
and the auto-differences of them. It can be used for uncon-
ditional walks or to seed the conditional walks with
comparably long simulations.
The conditional walk connecting a given start
with a certain end point by a given number of
steps needs an attraction term (the Q probability, see \link[eRTG3D]{qProb.3d})
to ensure that the target is approached and hit.
In order to calculate the Q probability for each step
the distribution of turns and lifts to target and
the distribution of distance to target has to be known.
They can be derived from the empirical data (ideally),
or estimated from an unconditional process with the same properties.
Creates a unconditional empirical random walk, with a specific starting point,
geometrically similar to the initial trajectory.
}
\section{Note}{

Simulations connecting start and end points
with more steps than 1/10th or more of the number of steps
of the empirical data should rather rely on simulated
unconditional walks with the same properties than on
the empirical data (\code{factor = 1500}).
}

\section{Random initial heading}{

For a random initial heading a0 use:
  \code{sample(atan2(diff(coordinates(track)[,2]), diff(coordinates(track)[,1])),1)}
}

\examples{
sim.uncond.3d(10, start=c(0,0,0), a0=pi/2, g0=pi/2, densities=get.track.densities.3d(niclas))
}
